/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util.time;

/**
 *	Representation of Date values.
 *	
 *	@author Xavier Franc. Most of this code borrowed from XMLmind XML Editor (courtesy
 *	of H. Shafie), and adapted (or botched-up).
 */
public class Date extends DateTimeBase
{
    public Date( int year, int month, int day, int tzSign, int tzHour, int tzMinute )
	throws DateTimeException {
        super( year, month, day, 0, 0, 0, tzSign, tzHour, tzMinute );
    }

    public Date( DateTimeBase dt ) throws DateTimeException {
        super( dt.year, dt.month, dt.day, 0, 0, 0, dt.tzSign, dt.tzHour, dt.tzMinute );
    }

    public DateTimeBase parse( String that, int implicitTimeZone ) throws DateTimeException {
	return parseDate(that, implicitTimeZone);
    }

    public static Date parseDate( String s, int implicitTimeZone )
	throws DateTimeException {
	int year;
	int month;
	int day;
	int[] tz = new int[3];

	int charCount = s.length();
	if (charCount == 0)
	    throw new DateTimeException("date syntax", s);

	int pos = 0;
	boolean negativeYear = false;
	if (s.charAt(pos) == '-') {
	    negativeYear = true;
	    ++pos;
	}
	int nextPos = s.indexOf('-', pos);
	if (nextPos < pos+4)
	    throw new DateTimeException("invalid syntax", s);
	year = parseInt(s, pos, nextPos);
	if (negativeYear)
	    year = -year;
	pos = nextPos + 1;

	if (pos+2 >= charCount || s.charAt(pos+2) != '-')
	    throw new DateTimeException("invalid syntax", s);
	month = parseInt(s, pos, pos+2);
	pos += 3;

	nextPos = parseTimeZone(s, pos, tz);
	if (nextPos != pos+2)
	    throw new DateTimeException("invalid syntax", s);

	day = parseInt(s, pos, nextPos);

	Date result = new Date(year, month, day, tz[0], tz[1], tz[2]);
	if(tz[0] == 0)
	    result.forceTimeZone( implicitTimeZone );
	return result;
    }

    public String toString() {
	StringBuffer buffer = new StringBuffer();

	if (year < 0) {
	    buffer.append('-');
	    appendPadded(- year, 4, buffer);
	} else
	    appendPadded(year, 4, buffer);
	buffer.append('-');
	appendPadded(month, 2, buffer);
	buffer.append('-');
	appendPadded(day, 2, buffer);
	appendTimeZone( tzSign, tzHour, tzMinute, buffer);

	return buffer.toString();
    }

} // end of class Date

