/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.util.time;

/**
 *	Representation of a GYear value.
 */
public class GYear extends DateTimeBase
{
    public GYear( int year, int tzSign, int tzHour, int tzMinute ) throws DateTimeException {
        super( year, 1, 1, 0, 0, 0, tzSign, tzHour, tzMinute );
    }

    public GYear( DateTimeBase dt ) throws DateTimeException {
        this( dt.year, dt.tzSign, dt.tzHour, dt.tzMinute );
    }

    public DateTimeBase parse( String that, int implicitTimeZone ) throws DateTimeException {
	return parseGYear(that);
    }

    public static GYear parseGYear(String s) throws DateTimeException {
	int year;
	int[] tz = new int[3];

	int charCount = s.length();
	if (charCount == 0)
	    throw new DateTimeException("invalid gYear syntax", s);

	int pos = 0;
	boolean negativeYear = false;
	if (s.charAt(pos) == '-') {
	    negativeYear = true;
	    ++pos;
	}
	int tzPos = parseTimeZone(s, pos, tz);
	if (tzPos < pos+4)
	    throw new DateTimeException("invalid gYear syntax", s);
	year = parseInt(s, pos, tzPos);
	if (negativeYear)
	    year = -year;

	return new GYear(year, tz[0], tz[1], tz[2]);
    }

    public String toString() {
	StringBuffer buffer = new StringBuffer();

	if (year < 0) {
	    buffer.append('-');
	    appendPadded( -year, 4, buffer);
	} else {
	    appendPadded(year, 4, buffer);
	}
	appendTimeZone( tzSign, tzHour, tzMinute, buffer);

	return buffer.toString();
    }
}
