/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.GlobalVariable;
import net.xfra.qizxopen.xquery.op.LocalVariable;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import java.text.Collator;

/**
 *	Context for static analysis.
 */
public interface StaticContext
{
    /**
     *	Returns the default function namespace.
     */
    Namespace getDefaultFunctionNS();
 
    /**
     *	Returns the default element namespace.
     */
    Namespace getDefaultElementNS();

    /**
     *	Returns the declared namespaces.
     */
    NSPrefixMapping getInScopeNS();

    //public void importSchema( ... );

    /**
     *	Looks for a function (user or predefined) in the static context:
     *  successively in current module, imported modules, predefined context.
     *  @return a user-, predefined-, or extension function, or null if not resolved.
     *  @throws XQueryException only when the access to an existing function is
     *  explicitly denied (e.g. security).
     */
    Function functionLookup( QName name ) throws XQueryException;

    /**
     *	Returns the declaration of a local variable
     */
    LocalVariable  lookforLocalVariable( QName name );

    /**
     *	Adds a local variable definition during compilation.
     */
    LocalVariable defineLocalVariable(QName name, Type type, Expression declaring);

    /**
     *	Returns the previous local variable definition (used for pop).
     */
    LocalVariable markLocalVariables();

    /**
     *	Pops local variable definitions during compilation.
     */
     void popLocalVariables(LocalVariable mark);

    /**
     *	Returns a global variable (null if not defined)
     */
    GlobalVariable lookforGlobalVariable(QName name);

    /**
     *	Converts a QName to prefix:ncname using the declared namespaces.
     */
    String    prefixedName( QName name );

    /**
     *	Returns the default element namespace.
     */
    String   getBaseURI();

    /**
     *	Gets the implementation-defined or query-defined default collation
     */
    String    getDefaultCollation();
    Collator  getCollator( String uri );

    

    /**
     *	Returns the current message log.
     */
    Log getLog();
    /**
     *	Convenience. Short form for  getLog().error(...)
     */
    void error( Expression place, String msg, String argument1, String argument2 );

    /**
     *	Wraps the static type checking of a subexpression.
     *	Flags can be Expression.UNORDERED, ...
     */
    Expression staticCheck(Expression expr, int flags);

    /**
     *	Returns the enclosing expression 'levels' above, returns null if none.
     */
    Expression getEnclosing( int levels );
    
    /**
     *	Checks an expression against a type, raises an error if no match.
     */
    void checkType( Expression expr, Type expected, String message );

    /**
     *	Checks an expression against a prototype argument, raises an error if no match.
     */
    boolean check( Prototype proto, int rank, Expression actualArgument );

    /**
     *	Finds the prototype that matches arguments, else emits an error.
     *  @param protos list of applicable prototypes
     *  @param actualArguments argument list to match
     *  @param call concerned expression, for error message.
     *  @return an expression instantiated from the class found in the matched prototype
     */
    Expression resolve( Prototype[] protos, Expression[] actualArguments,
			Expression call );

    /**
     *	Defines the type of '.' for the enclosed expression.
     */
    void pushDotType(Type type);
    void popDotType();
    ItemType getDotType();
}
