/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dm;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.dm.NodeSequence;
import net.xfra.qizxopen.xquery.*;

/**
 *  Represents the node test document-node(<element-test>).
 */
public class DocumentTest implements NodeTest {

    public NodeTest topTest;

    public DocumentTest( NodeTest topTest ) {
        this.topTest = topTest;
    }

    public String toString() {
	return "documentTest("+ topTest +")";
    }

    public int getNodeKind() {
	return Node.DOCUMENT;
    }

    public boolean staticallyCheckable() {
	return topTest == null;
    }

    public boolean accepts( int nodeKind, QName nodeName ) {
	return nodeKind == Node.DOCUMENT;
    }

    public boolean needsNode() { return true; }

    public boolean accepts( net.xfra.qizxopen.dm.Node node ) {
	if(node.getNature() != Node.DOCUMENT)
	    return false;
	if(topTest == null)
	    return true;
	NodeSequence kids = node.children();
	// must have exactly one element child, matching the topTest predicate
	boolean gotElement = false;
	for( ; kids.nextNode(); ) {
	    net.xfra.qizxopen.dm.Node kid = kids.currentNode();
	    if(kid.getNature() == Node.ELEMENT) {
		if (gotElement || !topTest.accepts(kid))
		    return false;
		gotElement = true;
	    }
	}
	return gotElement;
    }
}
