/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.dm;

import net.xfra.qizxopen.util.QName;
//import net.xfra.qizxopen.dm.Node;
//import net.xfra.qizxopen.dm.NodeSequence;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.BaseValue;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.StringValue;
import net.xfra.qizxopen.xquery.dt.SingleString;
import net.xfra.qizxopen.xquery.dt.UntypedAtomicType;
import java.text.Collator;

public abstract class NodeSequenceBase extends BaseValue
{
    public ItemType  getType() {
	return Type.NODE;
    }

    public boolean isNode() {
	return true;
    }

    public abstract Node asNode() throws TypeException ;

    public Item  asItem() throws TypeException {
	return asNode();
    }

    public Item  asAtom() throws TypeException {
	// this is OK for Basic XQ: improve it later
	return new SingleString(asNode().getStringValue(), Type.UNTYPED_ATOMIC);
    }

    public boolean asBoolean() throws TypeException {
	return true;
    }

    public String  asString()  throws TypeException {
	return asNode().getStringValue();
    }

    public long    asInteger() throws TypeException {
	return Conversion.toInteger( asString() ); 
    }

    public double  asDouble() throws TypeException {
	return Conversion.toDouble( asString() ); 
    }

    public int compareTo( Item that, Collator collator, int implicitTimeZone )
	throws TypeException {
	return UntypedAtomicType.comparison( this, that, collator);
    }
}
