/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.Binary;
import net.xfra.qizxopen.xquery.*;

public class HexBinaryType extends BinaryType {

    public String getShortName() {
        return "hexBinary";
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
	ItemType type = value.getType();
	Binary result = null;
	try {
	    if(type instanceof StringType)
		result = Binary.parseHexBinary( value.asString() );
	    else if(type instanceof BinaryType)
		result = ((BinaryValue) value).getValue();
	    else throw new IllegalArgumentException("invalid type "+type);
	} catch (IllegalArgumentException e) {
	    throw new TypeException("cannot cast to xs:hexBinary : "+ e.getMessage());
        }
	return new SingleBinary( result, Type.HEX_BINARY );
    }
}
