/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;

import java.util.Enumeration;
import java.util.Vector;
import java.util.ArrayList;

/**
 *	A sequence that stores Object items in an array.
 */
public class ObjectArraySequence extends GenericValue
{
    protected Object[] items;
    protected int size;
    protected int index = -1;

    public ObjectArraySequence( Object[] items, int size ) {
        this.items = items;
	this.size = size;
    }

    public ObjectArraySequence( Vector vector ) {
	items = vector.toArray();
	size = items.length;
    }

    public ObjectArraySequence( ArrayList vector ) {
	items = vector.toArray();
	size = items.length;
    }

    public ObjectArraySequence( Enumeration enu ) {
	Object[] items = new Object[4];
	int ptr = 0;
	for(; enu.hasMoreElements(); ) {
	    if(ptr >= items.length) {
		Object[] old = items;
		items = new Object[ old.length * 2 ];
		System.arraycopy(old, 0, items, 0, old.length);
	    }
	    items[ptr ++] = enu.nextElement();
        }
	this.items = items;
	this.size = ptr;
    }

    public boolean next() throws XQueryException {
	if(++ index >= size)
	    return false;
	if(items[index] instanceof String)
	    item = new SingleString( (String) items[index]);
	else
	    item = new SingleWrappedObject(items[index]);	// TODO OPTIM
	return true;
    }

    public Value  bornAgain() {
	return new ObjectArraySequence( items, size );
    }

    /**
     *	Converts a Value representing a sequence of objects into an array.
     */
    public static Object[] expand(Value value) throws XQueryException {
	Object[] items = new Object[8];
	int ptr = 0;
	for(; value.next(); ) {
	    if(ptr >= items.length) {
		Object[] old = items;
		items = new Object[ old.length * 2 ];
		System.arraycopy(old, 0, items, 0, old.length);
	    }
	    items[ptr ++] = ((WrappedObjectValue) value.asItem()).getObject();
        }
	// return a full array: TODO OPTIM
	if(ptr == items.length)
	    return items;
	Object[] ritems = new Object[ptr];
	System.arraycopy(items, 0, ritems, 0, ptr);
	return ritems;
    }
} 
