/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;

/**
 *	A scalar Boolean value.
 */
public class SingleBoolean extends BooleanValue
{
    private boolean value;
    private boolean started = false;

    public SingleBoolean( boolean value ) {
	this.value = value;
    }

    public boolean next() {
	return started ? false : (started = true);
    }

    public Value  bornAgain() {
	return new SingleBoolean(value);
    }

    public boolean asBoolean() {
	return value;
    }

} // end of class SingleBoolean

