/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.*;

/**
 *	A scalar QName value.
 */
public class SingleQName extends QNameValue
{
    private QName value;
    private boolean started = false;

    public SingleQName( QName value ) {
	this.value = value;
    }

    public boolean next() {
	return started ? false : (started = true);
    }

    public Value  bornAgain() {
	return new SingleQName(value);
    }

    public QName getValue() {
	return value;
    }

} // end of class SingleQName

