/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.time.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.SingleMoment;
import net.xfra.qizxopen.xquery.dt.DurationValue;

/**
 *  Implementation of function fn:adjust-to-timezone.
 */
public class AdjustToTimezone extends Function {

    static Prototype[] protos = { 
        Prototype.fn("adjust-to-timezone", Type.TIME.opt, Exec.class)
            .arg("val", Type.TIME.opt) .arg("timezone", Type.DURATION.opt),
        Prototype.fn("adjust-to-timezone", Type.DATE_TIME.opt, Exec.class)
            .arg("val", Type.DATE_TIME.opt) .arg("timezone", Type.DURATION.opt),
        Prototype.fn("adjust-to-timezone", Type.DATE.opt, Exec.class)
            .arg("val", Type.DATE.opt) .arg("timezone", Type.DURATION.opt)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Item v1 = args[0].evalAsOptItem(focus, context);
	    Item v2 = args[1].evalAsItem(focus, context);
	    if(v1 == null)
		throw EmptyException.allowed();
	    DateTimeBase time = ((MomentValue) v1).getValue();
	    Duration tzone = ((DurationValue) v2).getValue();
	    if(!tzone.checkAsTimezone())
		context.error(args[1], "invalid timezone value");
	    int minutes = (int) (tzone.getSeconds() / 60);
	    DateTimeBase res = time.adjustToTimezone( minutes );
	    try {
		if(v1.getType() == Type.TIME)
		    res = new Time(res);
	    }
	    catch (Exception e) { e.printStackTrace();  }	// should not happen
	    return new SingleMoment( res, v1.getType() );
        }
    }
}
