/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.xquery.*;
import java.text.Collator;

/**
 *  Implementation of function fn:deep-equal.
 */
public class DeepEqual extends Function {

    static Prototype[] protos = { 
        Prototype.fn("deep-equal", Type.BOOLEAN, Exec.class)
            .arg("parameter1", Type.ITEM.star)
            .arg("parameter2", Type.ITEM.star),
        Prototype.fn("deep-equal", Type.BOOLEAN, Exec.class)
            .arg("parameter1", Type.ITEM.star)
            .arg("parameter2", Type.ITEM.star)
            .arg("collationLiteral", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.BoolCall {

        public boolean evalAsBoolean(Focus focus, EvalContext context) throws XQueryException {
	    Value s1 = args[0].eval(focus, context);
	    Value s2 = args[1].eval(focus, context);
	    Collator collator = args.length < 3 ? 
		null : context.getCollator(args[2].evalAsString(focus, context));
            context.at(this);
	    for(;;) {
		if(!s1.next())
		    return !s2.next();
		else if(!s2.next())
		    return false;
		if( ! s1.asItem().deepEqual(s2.asItem(), collator))
		    return false;
	    }
        }
    }
}
