/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.impl.*;

/**
 *  Implementation of function fn:namespace-uri.
 */
public class NamespaceUri extends Function {

    static Prototype[] protos = { 
        Prototype.fn("namespace-uri", Type.STRING, Exec.class),
        Prototype.fn("namespace-uri", Type.STRING, Exec.class)
            .arg("srcval", Type.NODE.opt)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.StringCall {

        public String evalAsString(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Node node;
	    if(args.length == 0) {
		if(focus == null || !focus.getItem().isNode())
		    return "";
		node = focus.getItem().asNode();
	    }
	    else node = args[0].evalAsOptNode(focus, context);
	    QName name = node == null ? null : node.getNodeName();	
	    return name == null ? "" : name.getURI();
	}
    }
}
