/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import java.util.Vector;

public class IntegerLiteral extends IntegerExpression {

    public long  value;

    public IntegerLiteral( long value ) {
        this.value = value;
	type = Type.INTEGER;
    }

    public boolean visit(Visitor v) {
	return v.examine(this);
    }

    public void dump( ExprDump d ) {
	d.header( this, "IntegerLiteral "+value );
    }

    public int getFlags() {
	return CONSTANT;
    }

    public long evalAsInteger( Focus focus, EvalContext context) throws XQueryException {
	return  value;
    }
}
