/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.fn.Prototype;

/**
 *  class NumericOp: 
 * 
 */
public abstract class NumericOp extends Expression {

    public Expression[]  operands;

    public NumericOp( Expression expr1, Expression expr2 ) {
        operands = new Expression[] { expr1, expr2 };
    }

    public abstract Prototype[] getProtos();

    public boolean visit(Visitor v) {
	return v.examine(this) && operands[0].visit(v) && operands[1].visit(v);
    }

    public Expression staticCheck( StaticContext context ) {
	operands[0] = context.staticCheck(operands[0], 0);
	operands[1] = context.staticCheck(operands[1], 0);
        return context.resolve(getProtos(), operands, this );
    }
}
