/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.*;

/**
 *  class StringLiteral: 
 */
public class StringLiteral extends StringExpression {

    public String  value;

    public StringLiteral( String value ) {
        this.value = value;
    }

    public boolean visit(Visitor v) {
	return v.examine(this);
    }

    public void dump( ExprDump d ) {
	d.header( this, "StringLiteral '"+value+"'" );
    }

    public Expression staticCheck( StaticContext context ) {
	type = Type.STRING;
	return this;
    }

    public int getFlags() {
	return CONSTANT;
    }

    public String evalAsString(Focus focus, EvalContext context) throws XQueryException {
        return value;
    }
}
