/*
 * Decompiled with CFR 0.152.
 */
package com.sun.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class CatalogManager {
    private static String pFiles = "xml.catalog.files";
    private static String pVerbosity = "xml.catalog.verbosity";
    private static String pPrefer = "xml.catalog.prefer";
    private static String pStatic = "xml.catalog.staticCatalog";
    private static String pAllowPI = "xml.catalog.allowPI";
    private static String pClassname = "xml.catalog.className";
    private static String pIgnoreMissing = "xml.catalog.ignoreMissing";
    private static boolean ignoreMissingProperties = System.getProperty(pIgnoreMissing) != null || System.getProperty(pFiles) != null;
    private static ResourceBundle resources;
    private static String propertyFile;
    private static URL propertyFileURI;
    private static String defaultCatalogFiles;
    private static int defaultVerbosity;
    private static boolean defaultPreferPublic;
    private static boolean defaultStaticCatalog;
    private static boolean defaultOasisXMLCatalogPI;
    private static boolean defaultRelativeCatalogs;
    static /* synthetic */ Class class$com$sun$resolver$CatalogManager;

    private static synchronized void readProperties() {
        block6: {
            try {
                propertyFileURI = (class$com$sun$resolver$CatalogManager == null ? (class$com$sun$resolver$CatalogManager = CatalogManager.class$("com.sun.resolver.CatalogManager")) : class$com$sun$resolver$CatalogManager).getResource("/" + propertyFile);
                InputStream in = (class$com$sun$resolver$CatalogManager == null ? (class$com$sun$resolver$CatalogManager = CatalogManager.class$("com.sun.resolver.CatalogManager")) : class$com$sun$resolver$CatalogManager).getResourceAsStream("/" + propertyFile);
                if (in == null) {
                    if (!ignoreMissingProperties) {
                        System.err.println("Cannot find " + propertyFile);
                    }
                    return;
                }
                resources = new PropertyResourceBundle(in);
            }
            catch (MissingResourceException mre) {
                if (!ignoreMissingProperties) {
                    System.err.println("Cannot read " + propertyFile);
                }
            }
            catch (IOException e) {
                if (ignoreMissingProperties) break block6;
                System.err.println("Failure trying to read " + propertyFile);
            }
        }
    }

    public static void ignoreMissingProperties(boolean ignore) {
        ignoreMissingProperties = ignore;
    }

    /*
     * WARNING - void declaration
     */
    public static int verbosity() {
        String verbStr = System.getProperty(pVerbosity);
        if (verbStr == null) {
            if (resources == null) {
                CatalogManager.readProperties();
            }
            if (resources == null) {
                return defaultVerbosity;
            }
            try {
                verbStr = resources.getString("verbosity");
            }
            catch (MissingResourceException e) {
                return defaultVerbosity;
            }
        }
        try {
            void e;
            int verb = Integer.parseInt(verbStr.trim());
            return (int)e;
        }
        catch (Exception e) {
            System.err.println("Cannot parse verbosity: \"" + verbStr + "\"");
            return defaultVerbosity;
        }
    }

    public static boolean relativeCatalogs() {
        if (resources == null) {
            CatalogManager.readProperties();
        }
        if (resources == null) {
            return defaultRelativeCatalogs;
        }
        try {
            String allow = resources.getString("relative-catalogs");
            return allow.equalsIgnoreCase("true") || allow.equalsIgnoreCase("yes") || allow.equalsIgnoreCase("1");
        }
        catch (MissingResourceException e) {
            return defaultRelativeCatalogs;
        }
    }

    public static Vector catalogFiles() {
        String catalogList = System.getProperty(pFiles);
        boolean fromPropertiesFile = false;
        if (catalogList == null) {
            if (resources == null) {
                CatalogManager.readProperties();
            }
            if (resources != null) {
                try {
                    catalogList = resources.getString("catalogs");
                    fromPropertiesFile = true;
                }
                catch (MissingResourceException e) {
                    System.err.println(propertyFile + ": catalogs not found.");
                    catalogList = null;
                }
            }
        }
        if (catalogList == null) {
            catalogList = defaultCatalogFiles;
        }
        StringTokenizer files = new StringTokenizer(catalogList, ";");
        Vector<String> catalogs = new Vector<String>();
        while (files.hasMoreTokens()) {
            String catalogFile = files.nextToken();
            URL absURI = null;
            if (fromPropertiesFile && !CatalogManager.relativeCatalogs()) {
                try {
                    absURI = new URL(propertyFileURI, catalogFile);
                    catalogFile = absURI.toString();
                }
                catch (MalformedURLException mue) {
                    absURI = null;
                }
            }
            catalogs.add(catalogFile);
        }
        return catalogs;
    }

    public static boolean preferPublic() {
        String prefer = System.getProperty(pPrefer);
        if (prefer == null) {
            if (resources == null) {
                CatalogManager.readProperties();
            }
            if (resources == null) {
                return defaultPreferPublic;
            }
            try {
                prefer = resources.getString("prefer");
            }
            catch (MissingResourceException e) {
                return defaultPreferPublic;
            }
        }
        if (prefer == null) {
            return defaultPreferPublic;
        }
        return prefer.equalsIgnoreCase("public");
    }

    public static boolean staticCatalog() {
        String staticCatalog = System.getProperty(pStatic);
        if (staticCatalog == null) {
            if (resources == null) {
                CatalogManager.readProperties();
            }
            if (resources == null) {
                return defaultStaticCatalog;
            }
            try {
                staticCatalog = resources.getString("static-catalog");
            }
            catch (MissingResourceException e) {
                return defaultStaticCatalog;
            }
        }
        if (staticCatalog == null) {
            return defaultStaticCatalog;
        }
        return staticCatalog.equalsIgnoreCase("true") || staticCatalog.equalsIgnoreCase("yes") || staticCatalog.equalsIgnoreCase("1");
    }

    public static boolean allowOasisXMLCatalogPI() {
        String allow = System.getProperty(pAllowPI);
        if (allow == null) {
            if (resources == null) {
                CatalogManager.readProperties();
            }
            if (resources == null) {
                return defaultOasisXMLCatalogPI;
            }
            try {
                allow = resources.getString("allow-oasis-xml-catalog-pi");
            }
            catch (MissingResourceException e) {
                return defaultOasisXMLCatalogPI;
            }
        }
        if (allow == null) {
            return defaultOasisXMLCatalogPI;
        }
        return allow.equalsIgnoreCase("true") || allow.equalsIgnoreCase("yes") || allow.equalsIgnoreCase("1");
    }

    public static String catalogClassName() {
        String className = System.getProperty(pClassname);
        if (className == null) {
            if (resources == null) {
                CatalogManager.readProperties();
            }
            if (resources == null) {
                return null;
            }
            try {
                return resources.getString("catalog-class-name");
            }
            catch (MissingResourceException e) {
                return null;
            }
        }
        return className;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        propertyFile = "CatalogManager.properties";
        propertyFileURI = null;
        defaultCatalogFiles = "./xcatalog";
        defaultVerbosity = 1;
        defaultPreferPublic = true;
        defaultStaticCatalog = true;
        defaultOasisXMLCatalogPI = true;
        defaultRelativeCatalogs = true;
    }
}

