/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import net.xfra.qizxopen.dm.XMLSerializer;
import net.xfra.qizxopen.util.CLOptions;
import net.xfra.qizxopen.util.FileUtil;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Log;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQuery;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.XQueryProcessor;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.impl.SyntaxColorer;
import net.xfra.qizxopen.xquery.impl.Version;

public class XQuestGUI
extends JFrame
implements XQueryProcessor.PauseHandler {
    private static ResourceBundle resourceBundle = null;
    private static String MSG_ATTR = "MESSG";
    private static String APP = "Qizx/open";
    JSplitPane topSplit;
    JSplitPane dispSplit;
    JTabbedPane toolTabs;
    QEdit queryEdit;
    MessageView messages;
    JScrollPane itemView;
    JScrollPane nodeView;
    JTable itemList;
    JTree nodeDisplay;
    DefaultTreeModel treeModel;
    JMenuBar mbar;
    JMenu filesMenu;
    JMenu helpMenu;
    JFileChooser fileChooser;
    JDialog helpDialog;
    XQueryProcessor xproc;
    XMLSerializer serialOut;
    Log log;
    Item[] itemArray = new Item[100];
    int itemCount;
    Waiter waiter;
    XQuery execQuery;
    long execTime;
    XQueryException execError;
    EvalContext execPauseContext;
    public String queryFile;
    public boolean traceQuery = false;
    public String base = ".";
    public String inputURI = null;
    public String collInput = null;
    public String xmlInput = null;
    public String[] globals = new String[0];
    public String[] xmloptions = new String[0];
    public String[] appargs = new String[0];
    public String timezone;
    public String collation;
    static CLOptions options = new CLOptions("XQuest");
    Runnable queryExecution = new Runnable(){

        public void run() {
            long l = System.currentTimeMillis();
            XQuestGUI.this.queryEdit.setRunning(true);
            try {
                int n = 0;
                while (n < XQuestGUI.this.globals.length) {
                    int n2 = XQuestGUI.this.globals[n].indexOf(61);
                    if (n2 < 0) {
                        XQuestGUI.this.message("illegal variable initializer: " + XQuestGUI.this.globals[n]);
                        return;
                    }
                    XQuestGUI.this.xproc.initGlobal(QName.get(XQuestGUI.this.globals[n].substring(0, n2)), XQuestGUI.this.globals[n].substring(n2 + 1));
                    ++n;
                }
                XQuestGUI.this.execTime = -1L;
                XQuestGUI.this.execError = null;
                Value value = XQuestGUI.this.xproc.executeQuery(XQuestGUI.this.execQuery);
                XQuestGUI.this.itemCount = 0;
                while (value.next()) {
                    if (XQuestGUI.this.itemCount >= XQuestGUI.this.itemArray.length) {
                        Item[] itemArray = XQuestGUI.this.itemArray;
                        XQuestGUI.this.itemArray = new Item[2 * itemArray.length];
                        System.arraycopy(itemArray, 0, XQuestGUI.this.itemArray, 0, itemArray.length);
                    }
                    XQuestGUI.this.itemArray[XQuestGUI.this.itemCount++] = value.asItem();
                }
                XQuestGUI.this.execTime = System.currentTimeMillis() - l;
            }
            catch (XQueryException xQueryException) {
                XQuestGUI.this.execError = xQueryException;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                XQuestGUI.this.execError = new XQueryException("out of memory error", outOfMemoryError);
            }
            SwingUtilities.invokeLater(XQuestGUI.this.finishQueryExecution);
        }
    };
    Runnable finishQueryExecution = new Runnable(){

        public void run() {
            XQuestGUI.this.execPauseContext = null;
            if (XQuestGUI.this.execError != null) {
                XQuestGUI.this.message("execution:");
                if (XQuestGUI.this.execError instanceof EvalException) {
                    ((EvalException)XQuestGUI.this.execError).printStack(XQuestGUI.this.log, 20);
                    XQuestGUI.this.displayLog();
                } else {
                    XQuestGUI.this.displayLog();
                    XQuestGUI.this.message(XQuestGUI.this.execError.getMessage(), XQuestGUI.this.messages.errorStyle);
                }
            }
            XQuestGUI.this.queryEdit.setRunning(false);
            XQuestGUI.this.itemList.getSelectionModel().clearSelection();
            if (XQuestGUI.this.itemCount > 0) {
                XQuestGUI.this.itemList.getSelectionModel().setSelectionInterval(0, 0);
            } else {
                XQuestGUI.this.itemList.getSelectionModel().clearSelection();
            }
            XQuestGUI.this.itemList.revalidate();
            XQuestGUI.this.itemList.repaint();
            if (XQuestGUI.this.execTime >= 0L) {
                XQuestGUI.this.message(XQuestGUI.this.itemCount + " item(s), execution time: " + XQuestGUI.this.execTime + " ms");
            }
        }
    };
    Runnable pausedExecution = new Runnable(){

        public void run() {
            XQuestGUI.this.message("stopped in:");
            XQuestGUI.this.execPauseContext.printStack(XQuestGUI.this.log, 20);
            XQuestGUI.this.displayLog();
        }
    };

    public XQuestGUI(String string) {
        super(string);
    }

    public void start() throws XQueryException, IOException {
        this.xproc = new XQueryProcessor(this.base, this.base);
        if (this.inputURI != null) {
            this.xproc.setDocumentInput(this.inputURI);
        }
        if (this.collInput != null) {
            this.xproc.setCollectionInput(this.collInput);
        }
        if (this.xmlInput != null) {
            this.xproc.setInput(this.xmlInput);
        }
        if (this.timezone != null) {
            this.xproc.setImplicitTimezone(this.timezone);
        }
        if (this.collation != null) {
            this.xproc.setDefaultCollation(this.collation);
        }
        this.xproc.initGlobal(QName.get("arguments"), this.appargs);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                XQuestGUI.this.quit();
            }
        });
        this.createGUI();
        this.log = new GUILog();
        this.waiter = new Waiter();
        this.waiter.start();
        if (this.queryFile != null) {
            this.queryEdit.loadFrom(new File(this.queryFile));
        }
    }

    public static void usage() {
        System.err.println("usage!");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        try {
            XQuestGUI xQuestGUI = new XQuestGUI(APP);
            options.parse(stringArray, xQuestGUI);
            xQuestGUI.start();
            xQuestGUI.setSize(850, 700);
            xQuestGUI.setVisible(true);
        }
        catch (CLOptions.Exception exception) {
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    boolean doExecute(String string) {
        this.log.reset();
        this.changeNodeDisplay(null);
        int n = this.itemCount;
        while (--n >= 0) {
            this.itemArray[n] = null;
        }
        this.itemCount = 0;
        try {
            this.execQuery = this.xproc.compileQuery(string, "<input>", this.log);
        }
        catch (XQueryException xQueryException) {
            this.message("compilation:");
            this.displayLog();
            this.message(xQueryException.getMessage(), this.messages.errorStyle);
            return false;
        }
        this.waiter.perform(this.queryExecution);
        return true;
    }

    public void pauseAt(EvalContext evalContext) {
        this.execPauseContext = evalContext;
        SwingUtilities.invokeLater(this.pausedExecution);
    }

    synchronized void unpause() {
        this.execPauseContext = null;
        this.notify();
    }

    int message(String string) {
        return this.message(string, null);
    }

    int message(String string, AttributeSet attributeSet) {
        int n = this.messages.appendText(string, attributeSet);
        this.messages.appendText("\n", attributeSet);
        return n;
    }

    void displayLog() {
        Log.Message message;
        int n = 0;
        while ((message = this.log.getMessage(n)) != null) {
            Style style = message.severity == 3 ? this.messages.errorStyle : this.messages.noStyle;
            MutableAttributeSet mutableAttributeSet = this.messages.mutableStyle(style);
            mutableAttributeSet.addAttribute(MSG_ATTR, message);
            String string = message.severity == 3 ? "*** " : "    ";
            this.messages.appendText(string, mutableAttributeSet);
            this.message(message.expand(), mutableAttributeSet);
            ++n;
        }
        this.log.reset();
    }

    private void createGUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        this.createItemView();
        this.treeModel = new DefaultTreeModel(new DisplayNode(null));
        this.nodeDisplay = new JTree(this.treeModel);
        this.nodeView = new JScrollPane(this.nodeDisplay);
        XQuestGUI.setHeader(this.nodeView, new JLabel("XML tree: "));
        this.dispSplit = new JSplitPane(0, this.itemView, this.nodeView);
        this.dispSplit.setOneTouchExpandable(true);
        this.dispSplit.setDividerLocation(200);
        this.createTabs();
        this.topSplit = new JSplitPane(1, this.toolTabs, this.dispSplit);
        this.topSplit.setOneTouchExpandable(true);
        this.topSplit.setResizeWeight(0.3);
        this.topSplit.setDividerLocation(480);
        jPanel.add((Component)this.topSplit, "Center");
        this.buildMenu();
    }

    private void createTabs() {
        this.toolTabs = new JTabbedPane(1, 0);
        this.toolTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
            }
        });
        this.queryEdit = new QEdit();
        this.messages = new MessageView();
        JSplitPane jSplitPane = new JSplitPane(0, this.queryEdit, this.messages);
        jSplitPane.setResizeWeight(0.8);
        jSplitPane.setDividerLocation(300);
        this.toolTabs.addTab("Query input", null, jSplitPane, "Type and edit a XQuery");
    }

    void createItemView() {
        ItemTableModel itemTableModel = new ItemTableModel();
        this.itemList = new JTable(itemTableModel);
        ListSelectionModel listSelectionModel = this.itemList.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                block4: {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    int n = XQuestGUI.this.itemList.getSelectionModel().getMinSelectionIndex();
                    if (n < 0 || n >= XQuestGUI.this.itemCount) break block4;
                    try {
                        if (XQuestGUI.this.itemArray[n].isNode()) {
                            XQuestGUI.this.changeNodeDisplay(XQuestGUI.this.itemArray[n].asNode());
                            break block4;
                        }
                        XQuestGUI.this.changeNodeDisplay(null);
                    }
                    catch (XQueryException xQueryException) {
                        xQueryException.printStackTrace();
                    }
                }
            }
        });
        TableColumnModel tableColumnModel = this.itemList.getColumnModel();
        tableColumnModel.getColumn(0).setMinWidth(10);
        tableColumnModel.getColumn(0).setMaxWidth(50);
        tableColumnModel.getColumn(1).setMinWidth(20);
        tableColumnModel.getColumn(1).setMaxWidth(150);
        tableColumnModel.getColumn(2).setMinWidth(50);
        tableColumnModel.getColumn(2).setPreferredWidth(200);
        this.itemView = new JScrollPane(this.itemList);
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(new JLabel("Results:"));
        XQuestGUI.setHeader(this.itemView, jToolBar);
    }

    private void buildMenu() {
        this.mbar = new JMenuBar();
        this.setJMenuBar(this.mbar);
        this.filesMenu = new JMenu(XQuestGUI.loc("Files"));
        this.addCmd(this.filesMenu, "Open...", 79, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XQuestGUI.this.haveFileChooser();
                int n = XQuestGUI.this.fileChooser.showOpenDialog(XQuestGUI.this);
                if (n != 0) {
                    return;
                }
                File file = XQuestGUI.this.fileChooser.getSelectedFile();
                try {
                    XQuestGUI.this.queryEdit.loadFrom(file);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(XQuestGUI.this, "error", "cannot read file " + file + ": " + iOException.getMessage(), 0);
                }
            }
        });
        this.addCmd(this.filesMenu, "Save as...", 83, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XQuestGUI.this.haveFileChooser();
                int n = XQuestGUI.this.fileChooser.showSaveDialog(XQuestGUI.this);
                if (n != 0) {
                    return;
                }
                File file = XQuestGUI.this.fileChooser.getSelectedFile();
                try {
                    XQuestGUI.this.queryEdit.saveTo(file);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(XQuestGUI.this, "error", "cannot save to file " + file + ": " + iOException.getMessage(), 0);
                }
            }
        });
        this.addCmd(this.filesMenu, null, 0, null);
        this.addCmd(this.filesMenu, "Quit", 81, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XQuestGUI.this.quit();
            }
        });
        this.addCmd(this.filesMenu, null, 0, null);
        this.mbar.add(this.filesMenu);
        this.helpMenu = new JMenu(XQuestGUI.loc("Help"));
        this.addCmd(this.helpMenu, "Help", 0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XQuestGUI.this.help();
            }
        });
        this.addCmd(this.helpMenu, "About " + APP, 0, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                XQuestGUI.this.about();
            }
        });
        this.mbar.add(this.helpMenu);
    }

    void haveFileChooser() {
        if (this.fileChooser != null) {
            return;
        }
        this.fileChooser = new JFileChooser();
        URL uRL = this.getClass().getClassLoader().getResource("examples");
        File file = uRL != null ? FileUtil.urlToFile(uRL) : new File(".");
        this.fileChooser.setCurrentDirectory(file);
    }

    private void addCmd(JMenu jMenu, String string, int n, ActionListener actionListener) {
        if (string == null) {
            jMenu.addSeparator();
        } else {
            JMenuItem jMenuItem;
            JMenuItem jMenuItem2 = jMenuItem = n == 0 ? new JMenuItem(XQuestGUI.loc(string)) : new JMenuItem(XQuestGUI.loc(string), n);
            if (n != 0) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, 2));
            }
            jMenuItem.addActionListener(actionListener);
            jMenuItem.setActionCommand(string);
            jMenu.add(jMenuItem);
        }
    }

    static void setHeader(JScrollPane jScrollPane, JComponent jComponent) {
        JViewport jViewport = new JViewport();
        jViewport.setView(jComponent);
        jScrollPane.setColumnHeader(jViewport);
    }

    public static String loc(String string) {
        Object var1_1 = null;
        try {
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    ImageIcon getIcon(String string) {
        String string2 = "resources/" + string + ".gif";
        URL uRL = ClassLoader.getSystemResource(string2);
        return uRL == null ? null : new ImageIcon(uRL, string);
    }

    private void quit() {
        if (this.queryEdit.isModified() && JOptionPane.showConfirmDialog(this, "The current query is modified:\ndo you really want to quit?", "Warning", 2) != 0) {
            return;
        }
        System.exit(0);
    }

    private void help() {
        if (this.helpDialog == null) {
            this.helpDialog = new JDialog(this, "Help", false);
            JTextPane jTextPane = new JTextPane();
            JScrollPane jScrollPane = new JScrollPane(jTextPane);
            JToolBar jToolBar = new JToolBar();
            jToolBar.add(new JLabel("Help:   "));
            JButton jButton = new JButton("Close");
            jToolBar.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    XQuestGUI.this.helpDialog.setVisible(false);
                }
            });
            ImageIcon imageIcon = this.getIcon("zap");
            if (imageIcon != null) {
                jButton.setIcon(imageIcon);
            }
            XQuestGUI.setHeader(jScrollPane, jToolBar);
            this.helpDialog.getContentPane().add(jScrollPane);
            this.helpDialog.setSize(500, 500);
            Rectangle rectangle = this.getBounds();
            this.helpDialog.setLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            URL uRL = ClassLoader.getSystemResource("resources/help.html");
            if (uRL != null) {
                try {
                    jTextPane.setPage(uRL);
                }
                catch (IOException iOException) {
                    jTextPane.setText("error loading help file: " + iOException);
                }
            } else {
                jTextPane.setText("cannot locate help file");
            }
            jTextPane.setEditable(false);
        }
        this.helpDialog.setVisible(true);
    }

    private void about() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long l = runtime.totalMemory();
        long l2 = (l - runtime.freeMemory()) / 1024L;
        long l3 = runtime.maxMemory() / 1024L;
        String string = APP + " v" + Version.get() + "\n\n" + "Copyright \u00a9 2003-2004 Xavier C. Franc, all rights reserved.\n" + "\n" + "For more information, please visit http://www.xfra.net/qizxopen/\n" + "\n\n" + "Memory used " + l2 + " Kb, maximum " + l3 + " Kb\n\n";
        JOptionPane.showMessageDialog(this, string, "About " + APP, -1, null);
    }

    void changeNodeDisplay(Node node) {
        this.treeModel.setRoot(new DisplayNode(node));
        this.nodeDisplay.revalidate();
        this.nodeDisplay.repaint();
    }

    static {
        options.declare("-base", 1, "default base URI for libraries, documents and modules");
        options.declare("-D", "globals", 2, "variable_name=value!initialize a global variable defined in the query.");
        options.declare("--", "appargs", 5, "pass all following arguments to XQuery processor in variable '$arguments'");
        options.declare("-X", "xmloptions", 2, "option=value!set a XML serialization option.");
        options.declare("-input", "inputURI", 1, "URI of a document used as input (XQuery function input())");
        options.declare("-cinput", "collInput", 1, "URI of a collection used as input (XQuery function input())");
        options.declare("-xinput", "xmlInput", 1, "a XML fragment used as input (XQuery function input())");
        options.declare("-timezone", 1, "implicit timezone in duration format");
        options.declare("-collation", 1, "default collation");
        options.declare("-help", null, 6, "print this help");
        options.argument("<query file>", "queryFile", 0, "a file containing a query to load.");
        options.declare("-tex", "traceExceptions", 3, "verbose display of exceptions");
        options.declare("-tq", "traceQuery", 3, null);
    }

    public class GUILog
    extends Log {
        GUILog() {
        }

        public void printMessage(Log.Message message) {
        }
    }

    public class DisplayNode
    implements TreeNode {
        Node displayed;
        DisplayNode[] children;
        int childCnt = -1;

        DisplayNode(Node node) {
            this.displayed = node;
        }

        public TreeNode getChildAt(int n) {
            this.expand();
            return this.children[n];
        }

        public int getChildCount() {
            if (this.displayed == null) {
                return 0;
            }
            this.expand();
            return this.childCnt;
        }

        public boolean isLeaf() {
            if (this.displayed == null) {
                return false;
            }
            this.expand();
            return this.childCnt == 0;
        }

        public TreeNode getParent() {
            if (this.displayed == null) {
                return null;
            }
            return new DisplayNode(this.displayed.getParent());
        }

        public int getIndex(TreeNode treeNode) {
            return -1;
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public Enumeration children() {
            return null;
        }

        public String toString() {
            if (this.displayed == null) {
                return "<no node>";
            }
            String string = this.displayed.getNodeKind();
            QName qName = this.displayed.getNodeName();
            try {
                switch (this.displayed.getNature()) {
                    case 2: {
                        StringBuffer stringBuffer = new StringBuffer(string + " " + qName);
                        Value value = this.displayed.getAttributes();
                        while (value.next()) {
                            Node node = value.asNode();
                            stringBuffer.append(' ');
                            stringBuffer.append(node.getNodeName().toString());
                            stringBuffer.append('=');
                            stringBuffer.append(node.getStringValue());
                        }
                        return stringBuffer.toString();
                    }
                    case 6: 
                    case 7: {
                        return string + " " + this.displayed.getStringValue();
                    }
                    case 5: {
                        return string + " " + qName + " " + this.displayed.getStringValue();
                    }
                }
                return string;
            }
            catch (XQueryException xQueryException) {
                return xQueryException.toString();
            }
        }

        void expand() {
            if (this.childCnt >= 0) {
                return;
            }
            this.children = new DisplayNode[4];
            this.childCnt = 0;
            try {
                Value value = this.displayed.getChildren();
                while (value.next()) {
                    if (this.childCnt >= this.children.length) {
                        DisplayNode[] displayNodeArray = this.children;
                        this.children = new DisplayNode[displayNodeArray.length * 2];
                        System.arraycopy(displayNodeArray, 0, this.children, 0, displayNodeArray.length);
                    }
                    this.children[this.childCnt++] = new DisplayNode(value.asNode());
                }
            }
            catch (XQueryException xQueryException) {
                xQueryException.printStackTrace();
            }
        }
    }

    public class ItemTableModel
    extends AbstractTableModel {
        ItemTableModel() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return XQuestGUI.this.itemCount;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return new Integer(n);
                }
                case 1: {
                    return XQuestGUI.this.itemArray[n].getType().toString();
                }
                case 2: {
                    try {
                        if (!XQuestGUI.this.itemArray[n].isNode()) {
                            return XQuestGUI.this.itemArray[n].asString();
                        }
                        return "see below";
                    }
                    catch (XQueryException xQueryException) {
                        return "<error>";
                    }
                }
            }
            return "cell " + n + ":" + n2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "rank";
                }
                case 1: {
                    return "type";
                }
                case 2: {
                    return "value";
                }
            }
            return "?";
        }
    }

    public class MessageView
    extends TextPort
    implements CaretListener {
        Style errorStyle;
        Style noStyle;

        MessageView() {
            super("Messages:  ", 7, 30);
            this.addButton("Clear", "clear", "clear", "clear messages");
            this.errorStyle = this.addStyle("ERROR", new Color(15740960));
            this.noStyle = this.addStyle("PLAIN", new Color(0x505050));
            this.text.addCaretListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("clear")) {
                this.text.setText("");
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            Element element = this.doc.getCharacterElement(caretEvent.getDot());
            if (element == null) {
                return;
            }
            Object object = element.getAttributes().getAttribute(MSG_ATTR);
            if (object == null) {
                return;
            }
            Log.Message message = (Log.Message)object;
            if (message.module != null) {
                XQuestGUI.this.queryEdit.text.select(message.location, message.location + 1);
            }
        }
    }

    public class Waiter
    extends Thread {
        Object lock = new Object();
        Runnable task = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void perform(Runnable runnable) {
            this.task = runnable;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.task == null) continue;
                this.task.run();
            }
        }
    }

    public class QEdit
    extends TextPort
    implements DocumentListener {
        boolean modified;
        boolean locked;
        Thread timer;
        Style[] tokenStyles;
        Vector history = new Vector();
        int histoLoc;
        String savedCurrent;
        JButton execButton;
        JButton stopButton;
        JButton pauseButton;
        JButton stepButton;
        final Runnable refreshSyntax = new Runnable(this){
            private final /* synthetic */ QEdit this$1;
            {
                this.this$1 = qEdit;
            }

            public void run() {
                try {
                    Thread.sleep(500L);
                    SwingUtilities.invokeLater(this.this$1.redoSyntax);
                }
                catch (InterruptedException interruptedException) {}
            }
        };
        final Runnable redoSyntax = new Runnable(this){
            private final /* synthetic */ QEdit this$1;
            {
                this.this$1 = qEdit;
            }

            public void run() {
                this.this$1.timer = null;
                try {
                    SyntaxColorer syntaxColorer = new SyntaxColorer(this.this$1.text.getText());
                    int n = syntaxColorer.nextToken();
                    while (n > 0) {
                        int n2 = syntaxColorer.getTokenStart();
                        int n3 = syntaxColorer.getTokenLength();
                        this.this$1.doc.setCharacterAttributes(n2, n3, this.this$1.tokenStyles[n], true);
                        n = syntaxColorer.nextToken();
                    }
                }
                catch (XQueryException xQueryException) {
                    // empty catch block
                }
                this.this$1.text.revalidate();
            }
        };

        QEdit() {
            super("Query:  ", 12, 30);
            this.text.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 4, 0, 4)));
            this.execButton = this.addButton("Execute", "exec", "exec", "Compile and execute query");
            this.stopButton = this.addButton(null, "stop", "stop", "Abort execution");
            this.pauseButton = this.addButton(null, "pause", "pause", "Pause execution");
            this.setRunning(false);
            this.toolbar.add(new JToolBar.Separator());
            this.addButton(null, "clear", "clear", "clear the query edition area");
            this.toolbar.add(new JToolBar.Separator());
            this.addButton(null, "back", "previous", "previous query in history");
            this.addButton(null, "forward", "next", "next query in history");
            this.doc.addDocumentListener(this);
            this.tokenStyles = new Style[]{this.addStyle("dummy", Color.black), this.addStyle("TAG", new Color(36992)), this.addStyle("SPACE", Color.white), this.addStyle("NUMBER", new Color(0xC07000)), this.addStyle("STRING", new Color(0xC07000)), this.addStyle("MISC", new Color(0x303030)), this.addStyle("NAME", new Color(3166432)), this.addStyle("KEYWORD", new Color(16528)), this.addStyle("COMMENT", new Color(3203184)), this.addStyle("PRAGMA", new Color(12619888)), this.addStyle("FUNC", new Color(7352560))};
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("clear")) {
                this.text.setText("");
            } else if (string.equals("previous")) {
                if (this.histoLoc > 0) {
                    if (this.modified && this.histoLoc == this.history.size()) {
                        this.savedCurrent = this.text.getText();
                    }
                    --this.histoLoc;
                    this.locked = true;
                    this.text.setText((String)this.history.get(this.histoLoc));
                    this.locked = false;
                }
                this.debugHistory();
            } else if (string.equals("next")) {
                this.locked = true;
                if (this.histoLoc < this.history.size() - 1) {
                    ++this.histoLoc;
                    this.text.setText((String)this.history.get(this.histoLoc));
                } else if (this.savedCurrent != null) {
                    this.text.setText(this.savedCurrent);
                }
                this.locked = false;
                this.debugHistory();
            } else if (string.equals("exec")) {
                String string2 = this.text.getText();
                if (XQuestGUI.this.doExecute(string2) && this.modified) {
                    this.history.add(string2);
                    this.histoLoc = this.history.size();
                    this.modified = false;
                    this.savedCurrent = null;
                    this.debugHistory();
                }
            } else if (string.equals("stop")) {
                XQuestGUI.this.unpause();
                XQuestGUI.this.xproc.stopExecution();
            } else if (string.equals("pause")) {
                if (XQuestGUI.this.execPauseContext != null) {
                    XQuestGUI.this.unpause();
                } else {
                    XQuestGUI.this.xproc.pauseExecution(XQuestGUI.this);
                }
            } else if (string.equals("step")) {
                XQuestGUI.this.xproc.pauseExecution(XQuestGUI.this);
                XQuestGUI.this.unpause();
            }
        }

        void loadFrom(File file) throws IOException {
            String string = FileUtil.loadString(file);
            this.text.setText(string);
            this.modified = false;
        }

        void saveTo(File file) throws IOException {
            FileUtil.saveString(this.text.getText(), file);
            this.modified = false;
        }

        boolean isModified() {
            return this.modified;
        }

        void setRunning(boolean bl) {
            this.execButton.setEnabled(!bl);
            this.stopButton.setEnabled(bl);
            this.pauseButton.setEnabled(bl);
        }

        void debugHistory() {
        }

        void gotChange() {
            if (!this.locked) {
                this.modified = true;
                this.histoLoc = this.history.size();
            }
            XQuestGUI.this.waiter.perform(this.refreshSyntax);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.gotChange();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.gotChange();
        }
    }

    public abstract class TextPort
    extends JScrollPane
    implements ActionListener {
        JTextPane text;
        JToolBar toolbar;
        StyleContext styles = new StyleContext();
        StyledDocument doc = new DefaultStyledDocument();

        TextPort(String string, int n, int n2) {
            this.text = new JTextPane(this.doc);
            this.setViewportView(this.text);
            if (string != null) {
                this.toolbar = new JToolBar();
                JLabel jLabel = new JLabel(string);
                this.toolbar.add(jLabel);
                XQuestGUI.setHeader(this, this.toolbar);
            }
        }

        int appendText(String string, AttributeSet attributeSet) {
            try {
                int n = this.doc.getLength();
                this.doc.insertString(n, string, attributeSet);
                Rectangle rectangle = this.text.modelToView(this.doc.getLength());
                this.getViewport().scrollRectToVisible(rectangle);
                return n;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return this.doc.getLength();
            }
        }

        JButton addButton(String string, String string2, String string3, String string4) {
            JButton jButton = new JButton();
            jButton.setActionCommand(string3);
            jButton.setToolTipText(string4);
            jButton.addActionListener(this);
            ImageIcon imageIcon = XQuestGUI.this.getIcon(string2);
            if (imageIcon != null) {
                jButton.setIcon(imageIcon);
            } else if (string == null) {
                jButton.setText(string3);
            }
            if (string != null) {
                jButton.setText(string);
            }
            this.toolbar.add(jButton);
            return jButton;
        }

        Style addStyle(String string, Color color) {
            Style style = this.doc.addStyle(string, null);
            StyleConstants.setForeground(style, color);
            StyleConstants.setBold(style, true);
            return style;
        }

        MutableAttributeSet mutableStyle(Style style) {
            return new SimpleAttributeSet(style);
        }

        public abstract void actionPerformed(ActionEvent var1);
    }
}

