/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.dm;

import java.util.ArrayList;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.Node;
import net.xfra.qizxopen.dm.NodeSequence;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.util.GlobPattern;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.SoundsLikePattern;
import net.xfra.qizxopen.util.StringPattern;
import net.xfra.qizxopen.util.WordSifter;

public class FulltextQuery {
    public Clause[] required;
    public Clause[] excluded;
    public WordSifter wordSifter;
    int termCount;

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.required != null) {
            stringBuffer.append("required: ");
            n = 0;
            while (n < this.required.length) {
                stringBuffer.append(this.required[n].toString());
                ++n;
            }
        }
        if (this.excluded != null) {
            stringBuffer.append(" excluded: ");
            n = 0;
            while (n < this.excluded.length) {
                stringBuffer.append(this.excluded[n].toString());
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static FulltextQuery parseQuery(String string, WordSifter wordSifter) throws ParseException {
        return new Parser(wordSifter).parse(string);
    }

    public static FulltextQuery parsePhrase(String string, int n, WordSifter wordSifter) throws ParseException {
        return new Parser(wordSifter).parsePhrase(string, n);
    }

    public boolean matches(Node node) {
        WordFlow wordFlow = new WordFlow(32, this.termCount);
        this.parseWords(node, this.wordSifter, wordFlow);
        int n = 0;
        if (this.required != null) {
            int n2 = 0;
            while (n2 < this.required.length) {
                if (!this.required[n2].nextMatch(wordFlow, n, 0)) {
                    return false;
                }
                n += this.required[n2].terms.length;
                ++n2;
            }
        }
        if (this.excluded != null) {
            int n3 = 0;
            while (n3 < this.excluded.length) {
                if (this.excluded[n3].nextMatch(wordFlow, n, 0)) {
                    return false;
                }
                n += this.required[n3].terms.length;
                ++n3;
            }
        }
        return true;
    }

    private void parseWords(Node node, WordSifter wordSifter, WordFlow wordFlow) {
        switch (node.getNature()) {
            case 1: 
            case 2: {
                NodeSequence nodeSequence = node.children();
                while (nodeSequence.nextNode()) {
                    this.parseWords(nodeSequence.currentNode(), this.wordSifter, wordFlow);
                }
                break;
            }
            case 7: {
                char[] cArray = node.getChars();
                wordSifter.start(cArray, cArray.length);
                char[] cArray2 = wordSifter.nextWord();
                while (cArray2 != null) {
                    wordFlow.add(cArray2, node, wordSifter.wordOffset(), wordSifter.wordLength());
                    cArray2 = wordSifter.nextWord();
                }
                break;
            }
        }
    }

    public void highlight(Node node, Hiliter hiliter, XMLEventReceiver xMLEventReceiver) throws DataModelException {
        if (hiliter.areas == null) {
            hiliter.startHiliting(null);
        }
        this.hiTraversal(node, hiliter, xMLEventReceiver);
    }

    private void hiTraversal(Node node, Hiliter hiliter, XMLEventReceiver xMLEventReceiver) throws DataModelException {
        boolean bl = hiliter.start(node, xMLEventReceiver);
        switch (node.getNature()) {
            case 1: {
                xMLEventReceiver.startDocument();
                NodeSequence nodeSequence = node.children();
                while (nodeSequence.nextNode()) {
                    this.hiTraversal(nodeSequence.currentNode(), hiliter, xMLEventReceiver);
                }
                xMLEventReceiver.endDocument();
                break;
            }
            case 2: {
                Object object;
                xMLEventReceiver.startElement(node.getNodeName());
                NodeSequence nodeSequence = node.attributes();
                while (nodeSequence.nextNode()) {
                    object = nodeSequence.currentNode();
                    xMLEventReceiver.attribute(object.getNodeName(), object.getStringValue());
                }
                object = node.children();
                while (object.nextNode()) {
                    this.hiTraversal(object.currentNode(), hiliter, xMLEventReceiver);
                }
                xMLEventReceiver.endElement(node.getNodeName());
                break;
            }
            case 7: {
                if (bl) break;
                xMLEventReceiver.text(node.getStringValue());
                break;
            }
            case 5: {
                xMLEventReceiver.pi(node.getNodeName().toString(), node.getStringValue());
                break;
            }
            case 6: {
                xMLEventReceiver.comment(node.getStringValue());
            }
        }
    }

    public class Hiliter {
        public QName element = QName.get("span");
        public QName attribute = QName.get("class");
        public String pattern = "hi";
        ArrayList areas = new ArrayList();
        WordFlow flow;
        Node nextLitNode;
        int nextLitIndex;
        int nextLitClause;

        public void addMatchingArea(Node node) {
            if (this.areas == null) {
                this.areas = new ArrayList();
            }
            this.areas.add(node);
        }

        boolean start(Node node, XMLEventReceiver xMLEventReceiver) throws DataModelException {
            if (this.areas != null && this.areas.size() > 0 && node.equals(this.areas.get(0))) {
                this.areas.remove(0);
                this.startHiliting(node);
            }
            if (!node.equals(this.nextLitNode)) {
                return false;
            }
            int n = 0;
            String string = node.getStringValue();
            do {
                int n2 = this.flow.offsets[this.nextLitIndex];
                int n3 = this.flow.lengths[this.nextLitIndex];
                xMLEventReceiver.text(string.substring(n, n2));
                xMLEventReceiver.startElement(this.element);
                xMLEventReceiver.attribute(this.attribute, this.pattern + this.nextLitClause);
                n = n2 + n3;
                xMLEventReceiver.text(string.substring(n2, n));
                xMLEventReceiver.endElement(this.element);
                this.nextHilite();
            } while (node.equals(this.nextLitNode));
            xMLEventReceiver.text(string.substring(n));
            return true;
        }

        void startHiliting(Node node) {
            if (this.flow == null) {
                this.flow = new WordFlow(32, FulltextQuery.this.termCount);
            }
            this.flow.size = 0;
            FulltextQuery.this.parseWords(node, FulltextQuery.this.wordSifter, this.flow);
            this.nextLitIndex = -1;
            this.nextHilite();
            this.flow.forHilite = true;
        }

        void nextHilite() {
            int n = 0;
            if (FulltextQuery.this.required == null) {
                return;
            }
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            while (n3 < FulltextQuery.this.required.length) {
                int n4 = FulltextQuery.this.required[n3].terms.length;
                if (FulltextQuery.this.required[n3].nextMatch(this.flow, n, this.nextLitIndex + 1)) {
                    int n5 = 0;
                    while (n5 < n4) {
                        int n6 = this.flow.termPos[n + n5];
                        if (n6 < n2 && n6 > this.nextLitIndex) {
                            n2 = n6;
                            this.nextLitClause = n3;
                        }
                        ++n5;
                    }
                    n += n4;
                }
                ++n3;
            }
            this.nextLitIndex = n2;
            this.nextLitNode = this.nextLitIndex == Integer.MAX_VALUE ? null : this.flow.nodes[this.nextLitIndex];
        }
    }

    static class WordFlow {
        int size;
        char[][] words;
        Node[] nodes;
        int[] offsets;
        int[] lengths;
        int[] termPos;
        boolean forHilite;

        WordFlow(int n, int n2) {
            this.words = new char[n][];
            this.nodes = new Node[n];
            this.offsets = new int[n];
            this.lengths = new int[n];
            this.termPos = new int[n2];
        }

        void add(char[] cArray, Node node, int n, int n2) {
            if (this.size >= this.words.length) {
                int n3 = this.size * 2;
                Node[] nodeArray = this.nodes;
                this.nodes = new Node[n3];
                System.arraycopy(nodeArray, 0, this.nodes, 0, this.size);
                char[][] cArray2 = this.words;
                this.words = new char[n3][];
                System.arraycopy(cArray2, 0, this.words, 0, this.size);
                int[] nArray = this.offsets;
                this.offsets = new int[n3];
                System.arraycopy(nArray, 0, this.offsets, 0, this.size);
                nArray = this.lengths;
                this.lengths = new int[n3];
                System.arraycopy(nArray, 0, this.lengths, 0, this.size);
            }
            this.words[this.size] = cArray;
            this.nodes[this.size] = node;
            this.offsets[this.size] = n;
            this.lengths[this.size] = n2;
            ++this.size;
        }

        int nextMatchFrom(StringPattern stringPattern, int n, int n2) {
            int n3 = n;
            while (n3 < this.size) {
                if (this.words[n3] != null && stringPattern.matches(this.words[n3])) {
                    this.termPos[n2] = n3;
                    return this.termPos[n2];
                }
                ++n3;
            }
            this.termPos[n2] = Integer.MAX_VALUE;
            return -1;
        }
    }

    public static class ParseException
    extends Exception {
        ParseException(String string) {
            super(string);
        }
    }

    static class Parser {
        WordSifter sifter;

        Parser(WordSifter wordSifter) {
            this.sifter = wordSifter;
        }

        FulltextQuery parse(String string) throws ParseException {
            this.sifter.start(string.toCharArray(), string.length());
            FulltextQuery fulltextQuery = new FulltextQuery();
            fulltextQuery.wordSifter = this.sifter;
            if (!this.parseClause(fulltextQuery)) {
                throw new ParseException("empty query");
            }
            do {
                this.pickWord("AND");
            } while (this.parseClause(fulltextQuery));
            if (this.sifter.charAt(0) != '\u0000') {
                throw new ParseException("unrecognized data at end of query: '" + this.endOfQuery() + "'");
            }
            return fulltextQuery;
        }

        FulltextQuery parsePhrase(String string, int n) throws ParseException {
            this.sifter.start(string.toCharArray(), string.length());
            FulltextQuery fulltextQuery = new FulltextQuery();
            fulltextQuery.wordSifter = this.sifter;
            StringPattern[] stringPatternArray = null;
            StringPattern stringPattern = this.parseTerm();
            while (stringPattern != null) {
                stringPatternArray = this.append(stringPatternArray, stringPattern);
                stringPattern = this.parseTerm();
            }
            if (stringPatternArray == null) {
                throw new ParseException("empty phrase");
            }
            if (this.sifter.charAt(0) != '\u0000') {
                throw new ParseException("unrecognized data at end of phrase: '" + this.endOfQuery() + "'");
            }
            this.addClause(fulltextQuery, false, new Phrase(stringPatternArray, n));
            return fulltextQuery;
        }

        private StringBuffer endOfQuery() {
            StringBuffer stringBuffer = new StringBuffer();
            char c = this.sifter.charAt(0);
            while (c != '\u0000') {
                stringBuffer.append(c);
                c = this.sifter.nextChar();
            }
            return stringBuffer;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        boolean parseClause(FulltextQuery var1_1) throws ParseException {
            var2_2 = this.pickWord("NOT") != false || this.pick('-') != false;
            var3_3 = '\"';
            if (this.pick('\"')) ** GOTO lbl-1000
            var3_3 = '\'';
            if (this.pick('\'')) lbl-1000:
            // 2 sources

            {
                var4_4 = null;
                var5_6 = this.parseTerm();
                while (var5_6 != null) {
                    var4_4 = this.append(var4_4, var5_6);
                    var5_6 = this.parseTerm();
                }
                if (var4_4 == null) {
                    throw new ParseException("empty phrase");
                }
                if (!this.pick(var3_3)) {
                    throw new ParseException("end of phrase not found");
                }
                this.addClause(var1_1, var2_2, new Phrase(var4_4, this.parseDistance(4)));
            } else {
                var4_5 = this.parseTerm();
                if (var4_5 == null) {
                    return false;
                }
                var5_7 /* !! */  = null;
                if (this.pick('|') || this.pickWord("OR")) {
                    var6_8 = new StringPattern[]{var4_5};
                    do {
                        if ((var4_5 = this.parseTerm()) == null) {
                            throw new ParseException("expecting term after OR");
                        }
                        var6_8 = this.append(var6_8, var4_5);
                    } while (this.pick('|') || this.pickWord("OR"));
                    var5_7 /* !! */  = new TermOr(var6_8);
                } else {
                    var5_7 /* !! */  = new Term(var4_5);
                }
                this.addClause(var1_1, var2_2, var5_7 /* !! */ );
            }
            return true;
        }

        StringPattern parseTerm() throws ParseException {
            block9: {
                boolean bl;
                int n;
                char[] cArray;
                block10: {
                    char c;
                    do {
                        char c2;
                        this.skip();
                        cArray = new char[12];
                        n = 0;
                        char c3 = this.sifter.charAt(0);
                        char c4 = ' ';
                        c = this.sifter.wildcardSeveral();
                        char c5 = this.sifter.wildcardSingle();
                        if (!this.sifter.isWordStart(c3) && c3 != c5 && c3 != c && c3 != '[') break block9;
                        bl = false;
                        do {
                            if ((c3 == c5 || c3 == c || c3 == '[') && c4 != '\\') {
                                bl = true;
                            }
                            if (n >= cArray.length) {
                                char[] cArray2 = cArray;
                                cArray = new char[cArray2.length * 2];
                                System.arraycopy(cArray2, 0, cArray, 0, cArray2.length);
                            }
                            if (c3 == c) {
                                c3 = '*';
                            } else if (c3 == c5) {
                                c3 = '?';
                            }
                            cArray[n++] = this.sifter.mapChar(c3);
                            c4 = c3;
                            c2 = this.sifter.nextChar();
                            c3 = c2;
                        } while (this.sifter.isWordPart(c2) || c3 == c5 || c3 == c || c3 == '[' || bl && c3 == '^' || c3 == ']');
                        if (n != 1) break block10;
                    } while (cArray[0] != c);
                    throw new ParseException("invalid term: '" + c + "'");
                }
                if (bl) {
                    return new GlobPattern(cArray, n);
                }
                int n2 = this.parseDistance(1);
                if (n2 == 0) {
                    return new StringPattern(cArray, n);
                }
                return new SoundsLikePattern(cArray, n, n2);
            }
            return null;
        }

        int parseDistance(int n) {
            if (!this.pick('~')) {
                return 0;
            }
            char c = this.sifter.charAt(0);
            if (!Character.isDigit(c)) {
                return n;
            }
            int n2 = 0;
            while (Character.isDigit(c)) {
                n2 = 10 * n2 + c - 48;
                c = this.sifter.nextChar();
            }
            return n2;
        }

        /*
         * Unable to fully structure code
         */
        boolean pickWord(String var1_1) {
            this.skip();
            var2_2 = var1_1.length();
            var3_3 = 0;
            while (var3_3 < var2_2) {
                if (this.sifter.charAt(var3_3) != var1_1.charAt(var3_3)) {
                    return false;
                }
                ++var3_3;
            }
            if (!this.sifter.isWordPart(this.sifter.charAt(var2_2))) ** GOTO lbl13
            return false;
lbl-1000:
            // 1 sources

            {
                this.sifter.nextChar();
lbl13:
                // 2 sources

                ** while (--var2_2 >= 0)
            }
lbl14:
            // 1 sources

            return true;
        }

        boolean pick(char c) {
            this.skip();
            if (this.sifter.charAt(0) != c) {
                return false;
            }
            this.sifter.nextChar();
            return true;
        }

        void skip() {
            char c = this.sifter.charAt(0);
            while (c != '\u0000' && Character.isWhitespace(c)) {
                c = this.sifter.nextChar();
            }
        }

        void addClause(FulltextQuery fulltextQuery, boolean bl, Clause clause) {
            fulltextQuery.termCount += clause.terms.length;
            if (bl) {
                fulltextQuery.excluded = this.append(fulltextQuery.excluded, clause);
            } else {
                fulltextQuery.required = this.append(fulltextQuery.required, clause);
            }
        }

        Clause[] append(Clause[] clauseArray, Clause clause) {
            if (clauseArray == null) {
                return new Clause[]{clause};
            }
            Clause[] clauseArray2 = new Clause[clauseArray.length + 1];
            System.arraycopy(clauseArray, 0, clauseArray2, 0, clauseArray.length);
            clauseArray2[clauseArray.length] = clause;
            return clauseArray2;
        }

        StringPattern[] append(StringPattern[] stringPatternArray, StringPattern stringPattern) {
            if (stringPatternArray == null) {
                return new StringPattern[]{stringPattern};
            }
            StringPattern[] stringPatternArray2 = new StringPattern[stringPatternArray.length + 1];
            System.arraycopy(stringPatternArray, 0, stringPatternArray2, 0, stringPatternArray.length);
            stringPatternArray2[stringPatternArray.length] = stringPattern;
            return stringPatternArray2;
        }
    }

    public static class Term
    extends Clause {
        Term(StringPattern stringPattern) {
            this.terms = new StringPattern[]{stringPattern};
        }

        boolean nextMatch(WordFlow wordFlow, int n, int n2) {
            return wordFlow.nextMatchFrom(this.terms[0], n2, n) >= 0;
        }

        public String toString() {
            return " Term " + this.terms[0];
        }
    }

    public static class Phrase
    extends Clause {
        public int spacing;

        Phrase(StringPattern[] stringPatternArray, int n) {
            this.terms = stringPatternArray;
            this.spacing = n;
        }

        boolean nextMatch(WordFlow wordFlow, int n, int n2) {
            int n3;
            if (wordFlow.forHilite && n2 <= (n3 = wordFlow.termPos[n + this.terms.length - 1])) {
                return true;
            }
            while (true) {
                n3 = n2;
                int n4 = -1;
                int n5 = -1;
                int n6 = 0;
                while (n6 < this.terms.length) {
                    int n7 = wordFlow.nextMatchFrom(this.terms[n6], n3, n + n6);
                    if (n7 < 0) {
                        return false;
                    }
                    if (n4 < 0) {
                        n4 = n7;
                    }
                    n5 = n7;
                    n3 = n7 + 1;
                    ++n6;
                }
                if (n5 - n4 <= this.terms.length + this.spacing - 1) {
                    return true;
                }
                n2 = n4 + 1;
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(" Phrase(");
            int n = 0;
            while (n < this.terms.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.terms[n].toString());
                ++n;
            }
            return stringBuffer.append("/" + this.spacing).append(")").toString();
        }
    }

    public static class TermOr
    extends Clause {
        TermOr(StringPattern[] stringPatternArray) {
            this.terms = stringPatternArray;
        }

        boolean nextMatch(WordFlow wordFlow, int n, int n2) {
            boolean bl = false;
            int n3 = 0;
            while (n3 < this.terms.length) {
                int n4 = wordFlow.nextMatchFrom(this.terms[n3], n2, n + n3);
                if (n4 >= 0) {
                    if (wordFlow.forHilite) {
                        bl = true;
                    } else {
                        return true;
                    }
                }
                ++n3;
            }
            return bl;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(" Or(");
            int n = 0;
            while (n < this.terms.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.terms[n].toString());
                ++n;
            }
            return stringBuffer.append(")").toString();
        }
    }

    public static abstract class Clause {
        public StringPattern[] terms;

        abstract boolean nextMatch(WordFlow var1, int var2, int var3);
    }
}

