/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.ext;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLSerializer;
import net.xfra.qizxopen.util.LimitReachedException;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Log;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQuery;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.XQueryProcessor;
import net.xfra.qizxopen.xquery.dm.EventDrivenBuilder;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.ArraySequence;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.impl.Module;
import net.xfra.qizxopen.xquery.op.Expression;

public class XfnInteractiveEval
extends Function {
    static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "interactive-eval");
    static Prototype[] protos = new Prototype[]{new Prototype(qfname, Type.NODE.star, class$net$xfra$qizxopen$ext$XfnInteractiveEval$Exec == null ? (class$net$xfra$qizxopen$ext$XfnInteractiveEval$Exec = XfnInteractiveEval.class$("net.xfra.qizxopen.ext.XfnInteractiveEval$Exec")) : class$net$xfra$qizxopen$ext$XfnInteractiveEval$Exec).arg("query", (Type)Type.STRING).arg("options", (Type)Type.NODE.star), new Prototype(qfname, Type.NODE.star, class$net$xfra$qizxopen$ext$XfnInteractiveEval$Exec == null ? (class$net$xfra$qizxopen$ext$XfnInteractiveEval$Exec = XfnInteractiveEval.class$("net.xfra.qizxopen.ext.XfnInteractiveEval$Exec")) : class$net$xfra$qizxopen$ext$XfnInteractiveEval$Exec).arg("query", (Type)Type.STRING)};
    static /* synthetic */ Class class$net$xfra$qizxopen$ext$XfnInteractiveEval$Exec;

    public Prototype[] getProtos() {
        return protos;
    }

    private static String trimString(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = 0;
        int n3 = stringBuffer.length();
        while (n2 < n3) {
            if (stringBuffer.charAt(n2) != '\r') {
                stringBuffer.setCharAt(n++, stringBuffer.charAt(n2));
            }
            ++n2;
        }
        return stringBuffer.substring(0, n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Exec
    extends Function.Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            ArraySequence arraySequence;
            block27: {
                evalContext.at(this);
                String string = this.args[0].evalAsString(focus, evalContext);
                string = string.replace('\r', ' ');
                Node node = this.args.length < 2 ? null : this.args[1].evalAsOptNode(focus, evalContext);
                QName qName = QName.get("pre");
                QName qName2 = QName.get("pre");
                QName qName3 = QName.get("class");
                int n = -1;
                int n2 = -1;
                int n3 = -1;
                boolean bl = true;
                boolean bl2 = false;
                StringWriter stringWriter = null;
                PrintWriter printWriter = null;
                Log log = null;
                EventDrivenBuilder eventDrivenBuilder = new EventDrivenBuilder();
                arraySequence = new ArraySequence(4);
                try {
                    Object object;
                    Object object2;
                    if (node != null) {
                        object2 = node.getAttributes();
                        while (object2.next()) {
                            object = object2.asNode();
                            String string2 = object.getNodeName().getLocalName();
                            if (string2.equals("escaped")) {
                                bl = object.getStringValue().equals("true");
                                continue;
                            }
                            if (string2.equals("output-max")) {
                                n3 = Integer.parseInt(object.getStringValue());
                                continue;
                            }
                            if (string2.equals("time-max")) {
                                n = Integer.parseInt(object.getStringValue());
                                continue;
                            }
                            if (!string2.equals("item-max")) continue;
                            n2 = Integer.parseInt(object.getStringValue());
                        }
                    }
                    stringWriter = new StringWriter();
                    printWriter = new PrintWriter(stringWriter);
                    log = new Log(printWriter);
                    object2 = (XQueryProcessor)evalContext.getProperty(":processor");
                    object = ((XQueryProcessor)object2).compileQuery(string, "query", log);
                    if (n3 > 0) {
                        eventDrivenBuilder.setMaxVolume(n3);
                    }
                    if (n > 0) {
                        ((XQueryProcessor)object2).setSysProperty(":timeout", new Integer(n));
                    }
                    try {
                        long l = System.currentTimeMillis();
                        Value value = ((XQueryProcessor)object2).executeQuery((XQuery)object);
                        value.setLazy(true);
                        int n4 = 0;
                        while (value.next()) {
                            ++n4;
                        }
                        long l2 = System.currentTimeMillis();
                        eventDrivenBuilder.startElement(qName);
                        eventDrivenBuilder.attribute(qName3, "header");
                        eventDrivenBuilder.text("Query executed in " + (l2 - l) + " milliseconds, returns ");
                        if (n4 == 0) {
                            eventDrivenBuilder.text("empty sequence");
                        } else {
                            eventDrivenBuilder.text(n4 + " item" + (n4 > 1 ? "s" : "") + ":");
                        }
                        eventDrivenBuilder.endElement(qName);
                        arraySequence.addItem(eventDrivenBuilder.crop());
                        XMLSerializer xMLSerializer = new XMLSerializer();
                        if (n3 > 0) {
                            xMLSerializer.setMaxVolume(n3);
                        }
                        xMLSerializer.definePrefixHints(((Module)object).getInScopeNS());
                        xMLSerializer.setOption("omit-xml-declaration", "yes");
                        if (bl) {
                            eventDrivenBuilder.reset();
                            eventDrivenBuilder.startElement(qName2);
                            eventDrivenBuilder.attribute(qName3, "items");
                        }
                        value = value.bornAgain();
                        int n5 = 1;
                        while (value.next()) {
                            if (n2 > 0 && n5 > n2) {
                                throw new LimitReachedException("too many items");
                            }
                            Item item = value.asItem();
                            Node node2 = null;
                            if (item.isNode() && !bl && (node2 = item.asNode()).getNature() != 7) {
                                arraySequence.addItem(node2);
                            } else if (item.isNode()) {
                                stringWriter = new StringWriter();
                                printWriter = new PrintWriter(stringWriter);
                                xMLSerializer.setOutput(printWriter);
                                xMLSerializer.reset();
                                xMLSerializer.traverse(item.asNode());
                                xMLSerializer.terminate();
                                eventDrivenBuilder.text(XfnInteractiveEval.trimString(stringWriter.getBuffer()));
                            } else {
                                eventDrivenBuilder.atom(value.asString());
                            }
                            ++n5;
                        }
                        if (!bl) break block27;
                        eventDrivenBuilder.endElement(qName2);
                        eventDrivenBuilder.terminate();
                        arraySequence.addItem(eventDrivenBuilder.crop());
                    }
                    catch (LimitReachedException limitReachedException) {
                        if (bl) {
                            eventDrivenBuilder.setMaxVolume(-1);
                            eventDrivenBuilder.endElement(qName2);
                            eventDrivenBuilder.terminate();
                            arraySequence.addItem(eventDrivenBuilder.crop());
                        }
                        eventDrivenBuilder.reset();
                        eventDrivenBuilder.startElement(qName);
                        eventDrivenBuilder.attribute(qName3, "runtime-error");
                        eventDrivenBuilder.text("** truncated display: " + limitReachedException.getMessage() + " **");
                        eventDrivenBuilder.endElement(qName);
                        arraySequence.addItem(eventDrivenBuilder.crop());
                    }
                    catch (EvalException evalException) {
                        evalException.printStack(log, 20);
                        if (evalException.getCause() != null && bl2) {
                            log.info("  caused by: " + evalException.getCause());
                        }
                        log.flush();
                        eventDrivenBuilder.startElement(qName);
                        eventDrivenBuilder.attribute(qName3, "runtime-error");
                        eventDrivenBuilder.text(stringWriter.toString());
                        eventDrivenBuilder.endElement(qName);
                        arraySequence.addItem(eventDrivenBuilder.crop());
                    }
                }
                catch (Exception exception) {
                    try {
                        log.flush();
                        eventDrivenBuilder.startElement(qName);
                        eventDrivenBuilder.attribute(qName3, "error");
                        printWriter.println("*** " + exception.getMessage());
                        printWriter.flush();
                        eventDrivenBuilder.text(stringWriter.toString());
                        eventDrivenBuilder.endElement(qName);
                        arraySequence.addItem(eventDrivenBuilder.crop());
                    }
                    catch (DataModelException dataModelException) {
                        evalContext.error((Expression)this, "serialization error: " + dataModelException.getMessage());
                    }
                }
            }
            return arraySequence;
        }
    }
}

