/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.util.time;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.xfra.qizxopen.util.Util;
import net.xfra.qizxopen.util.time.DateTime;
import net.xfra.qizxopen.util.time.DateTimeException;

public abstract class DateTimeBase {
    int year;
    byte month;
    byte day;
    byte hour;
    byte minute;
    double second;
    byte tzSign;
    byte tzHour;
    byte tzMinute;
    static Calendar workCal = Calendar.getInstance(TimeZone.getTimeZone("WET"));
    public static final int EPOCH = 1970;
    public static DecimalFormat SECOND_FORMAT = new DecimalFormat("0.####################", new DecimalFormatSymbols(Locale.US));

    public DateTimeBase() {
    }

    public DateTimeBase(long l, int n) {
        this.setSecondsFromEpoch((double)l / 1000.0, n);
    }

    public DateTimeBase(DateTime dateTime) throws DateTimeException {
        this(dateTime.year, dateTime.month, dateTime.day, dateTime.hour, dateTime.minute, dateTime.second, dateTime.tzSign, dateTime.tzHour, dateTime.tzMinute);
    }

    public DateTimeBase(int n, int n2, int n3, int n4, int n5, double d, int n6, int n7, int n8) throws DateTimeException {
        if (n2 < 1 || n2 > 12) {
            throw new DateTimeException("invalid month");
        }
        if (n3 < 1 || n3 > DateTimeBase.lastDayOfMonth(n2, n)) {
            throw new DateTimeException("invalid day");
        }
        if (n4 < 0 || n4 > 23) {
            throw new DateTimeException("invalid hour");
        }
        if (n5 < 0 || n5 > 59) {
            throw new DateTimeException("invalid minute");
        }
        if (d < 0.0 || d > 60.0) {
            throw new DateTimeException("invalid second");
        }
        if (n6 < -1 || n6 > 1) {
            throw new DateTimeException("invalid tzSign");
        }
        if (n7 < 0 || n7 > 23) {
            throw new DateTimeException("invalid tzHour");
        }
        if (n8 < 0 || n8 > 59) {
            throw new DateTimeException("invalid tzMinute");
        }
        if (n6 == -1 && n7 == 0 && n8 == 0) {
            n6 = 1;
        }
        this.year = n;
        this.month = (byte)n2;
        this.day = (byte)n3;
        this.hour = (byte)n4;
        this.minute = (byte)n5;
        this.second = d;
        this.tzSign = (byte)n6;
        this.tzHour = (byte)n7;
        this.tzMinute = (byte)n8;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public double getSecond() {
        return this.second;
    }

    public int getTimeZoneSign() {
        return this.tzSign;
    }

    public int getTimeZoneHour() {
        return this.tzHour;
    }

    public int getTimeZoneMinute() {
        return this.tzMinute;
    }

    public double getSecondsFromEpoch() {
        return this.getMillisecondsFromEpoch() / 1000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMillisecondsFromEpoch() {
        Calendar calendar = workCal;
        synchronized (calendar) {
            workCal.set(1, this.year);
            workCal.set(2, this.month - 1);
            workCal.set(5, this.day);
            workCal.set(11, this.hour);
            workCal.set(12, this.minute);
            int n = (int)this.second;
            workCal.set(13, n);
            workCal.set(14, 0);
            workCal.add(11, this.tzSign > 0 ? -this.tzHour : this.tzHour);
            workCal.add(12, this.tzSign > 0 ? -this.tzMinute : this.tzMinute);
            return (double)workCal.getTimeInMillis() + 1000.0 * (this.second - (double)n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSecondsFromEpoch(double d, int n) {
        Calendar calendar = workCal;
        synchronized (calendar) {
            long l = (long)((d += (double)(n * 60)) * 1000.0);
            workCal.setTimeInMillis(l);
            this.year = workCal.get(1);
            this.month = (byte)(workCal.get(2) + 1);
            this.day = (byte)workCal.get(5);
            this.hour = (byte)workCal.get(11);
            this.minute = (byte)workCal.get(12);
            this.second = (double)workCal.get(13) + (double)workCal.get(14) / 1000.0 + (d - (double)l / 1000.0);
            this.forceTimeZone(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DateTime fromDate(Date date, int n) {
        Calendar calendar = workCal;
        synchronized (calendar) {
            workCal.setTime(date);
            DateTime dateTime = new DateTime();
            dateTime.year = workCal.get(1);
            dateTime.month = (byte)(workCal.get(2) + 1);
            dateTime.day = (byte)workCal.get(5);
            dateTime.hour = (byte)workCal.get(11);
            dateTime.minute = (byte)workCal.get(12);
            dateTime.second = (double)workCal.get(13) + (double)workCal.get(14) / 1000.0;
            dateTime.forceTimeZone(n);
            return dateTime;
        }
    }

    public abstract DateTimeBase parse(String var1, int var2) throws DateTimeException;

    public int hashCode() {
        long l = Double.doubleToRawLongBits(this.getSecondsFromEpoch());
        return (int)(l >>> 32 ^ l);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DateTimeBase)) {
            return false;
        }
        return this.compareTo((DateTimeBase)object) == 0;
    }

    public int compareTo(DateTimeBase dateTimeBase) {
        double d = this.getSecondsFromEpoch();
        double d2 = dateTimeBase.getSecondsFromEpoch();
        return Util.comparison(d - d2);
    }

    public DateTimeBase adjustToTimezone(int n) {
        DateTime dateTime = new DateTime();
        dateTime.setSecondsFromEpoch(this.getSecondsFromEpoch(), n);
        return dateTime;
    }

    public DateTimeBase addSeconds(double d) {
        DateTime dateTime = new DateTime();
        dateTime.setSecondsFromEpoch(this.getSecondsFromEpoch() + d, this.getTimeZone());
        return dateTime;
    }

    public static int parseNonNegativeInt(String string, int n, int n2) throws DateTimeException {
        int n3 = DateTimeBase.parseInt(string, n, n2);
        if (n3 < 0) {
            throw new DateTimeException("syntax error", string);
        }
        return n3;
    }

    public static int parseInt(String string, int n, int n2) throws DateTimeException {
        int n3;
        try {
            n3 = Integer.parseInt(string.substring(n, n2));
        }
        catch (Exception exception) {
            throw new DateTimeException("syntax error", string);
        }
        return n3;
    }

    public static double parseNonNegativeDouble(String string, int n, int n2) throws DateTimeException {
        double d = DateTimeBase.parseDouble(string, n, n2);
        if (d < 0.0) {
            throw new DateTimeException("syntax error", string);
        }
        return d;
    }

    public static double parseDouble(String string, int n, int n2) throws DateTimeException {
        double d;
        String string2 = string.substring(n, n2);
        int n3 = string2.length();
        int n4 = 0;
        while (n4 < n3) {
            switch (string2.charAt(n4)) {
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                default: {
                    throw new DateTimeException("syntax error", string);
                }
            }
            ++n4;
        }
        try {
            d = Double.parseDouble(string2);
        }
        catch (Exception exception) {
            throw new DateTimeException("syntax error", string);
        }
        return d;
    }

    public void forceTimeZone(int n) {
        this.tzSign = 1;
        if (n < 0) {
            n = -n;
            this.tzSign = (byte)-1;
        }
        this.tzHour = (byte)(n / 60);
        this.tzMinute = (byte)(n - 60 * this.tzHour);
    }

    public int getTimeZone() {
        return this.tzSign * (this.tzHour * 60 + this.tzMinute);
    }

    public static int parseTimeZone(String string, int n, int[] nArray) throws DateTimeException {
        int n2;
        int n3;
        boolean bl;
        int n4;
        int n5 = string.length();
        int n6 = string.indexOf(90, n);
        if (n6 < 0) {
            n6 = string.indexOf(43, n);
            if (n6 < 0) {
                n6 = string.indexOf(45, n);
                if (n6 < 0) {
                    n4 = 0;
                    bl = false;
                    n = n6 = n5;
                } else {
                    n4 = -1;
                    bl = true;
                    n = n6 + 1;
                }
            } else {
                n4 = 1;
                bl = true;
                n = n6 + 1;
            }
        } else {
            n4 = 1;
            bl = false;
            n = n6 + 1;
        }
        if (bl) {
            if (n + 2 >= n5 || string.charAt(n + 2) != ':') {
                throw new DateTimeException("syntax error", string);
            }
            n3 = DateTimeBase.parseInt(string, n, n + 2);
            if ((n += 3) + 2 != n5) {
                throw new DateTimeException("syntax error", string);
            }
            n2 = DateTimeBase.parseInt(string, n, n5);
        } else {
            if (n != n5) {
                throw new DateTimeException("syntax error", string);
            }
            n2 = 0;
            n3 = 0;
        }
        nArray[0] = n4;
        nArray[1] = n3;
        nArray[2] = n2;
        return n6;
    }

    public static int lastDayOfMonth(int n, int n2) {
        switch (n) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                if (!DateTimeBase.isLeapYear(n2)) break;
                return 29;
            }
        }
        return 28;
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public static void appendPadded(int n, int n2, StringBuffer stringBuffer) {
        String string = Integer.toString(n);
        int n3 = string.length();
        while (n3 < n2) {
            stringBuffer.append('0');
            ++n3;
        }
        stringBuffer.append(string);
    }

    public static void appendPadded(double d, int n, StringBuffer stringBuffer) {
        String string = SECOND_FORMAT.format(d);
        int n2 = string.indexOf(46);
        if (n2 < 0) {
            n2 = string.length();
        }
        while (n2 < n) {
            stringBuffer.append('0');
            ++n2;
        }
        stringBuffer.append(string);
    }

    public static void appendTimeZone(int n, int n2, int n3, StringBuffer stringBuffer) {
        if (n == 0) {
            return;
        }
        if (n2 == 0 && n3 == 0) {
            stringBuffer.append('Z');
            return;
        }
        stringBuffer.append(n == -1 ? (char)'-' : '+');
        DateTimeBase.appendPadded(n2, 2, stringBuffer);
        stringBuffer.append(':');
        DateTimeBase.appendPadded(n3, 2, stringBuffer);
    }

    static {
        SECOND_FORMAT.setParseIntegerOnly(false);
        SECOND_FORMAT.setGroupingUsed(false);
        SECOND_FORMAT.setDecimalSeparatorAlwaysShown(false);
        SECOND_FORMAT.setMinimumFractionDigits(0);
    }
}

