/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.FloatArraySequence;
import net.xfra.qizxopen.xquery.dt.NumericType;
import net.xfra.qizxopen.xquery.dt.SingleFloat;
import net.xfra.qizxopen.xquery.op.Expression;

public class FloatType
extends NumericType {
    public String getShortName() {
        return "float";
    }

    public boolean accepts(Type type) {
        return Type.NUMERIC.accepts(type) && type != Type.DOUBLE;
    }

    public Value cast(Value value, EvalContext evalContext) throws TypeException {
        try {
            return new SingleFloat((float)value.asDouble());
        }
        catch (TypeException typeException) {
            TypeException typeException2 = new TypeException("cannot cast to float: " + typeException.getMessage());
            typeException2.setContext(evalContext);
            throw typeException2;
        }
    }

    public Value convertFromObject(Object object) {
        return new SingleFloat(((Float)object).floatValue());
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws XQueryException {
        return new Float(expression.evalAsFloat(focus, evalContext));
    }

    public Value convertFromArray(Object object) {
        float[] fArray = (float[])object;
        return new FloatArraySequence(fArray, fArray.length);
    }

    public Object convertToArray(Value value) throws XQueryException {
        return FloatArraySequence.expandFloats(value);
    }
}

