/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EmptyException;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.EventDrivenBuilder;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.SingleBoolean;
import net.xfra.qizxopen.xquery.dt.SingleDouble;
import net.xfra.qizxopen.xquery.dt.SingleFloat;
import net.xfra.qizxopen.xquery.dt.SingleInteger;
import net.xfra.qizxopen.xquery.dt.SingleNode;
import net.xfra.qizxopen.xquery.dt.SingleString;
import net.xfra.qizxopen.xquery.dt.WrappedObjectValue;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;

public abstract class Function {
    public Expression staticCheck(StaticContext staticContext, Expression[] expressionArray, Expression expression) {
        return staticContext.resolve(this.getProtos(), expressionArray, expression);
    }

    public QName getName() {
        return this.getProtos()[0].qname;
    }

    public abstract Prototype[] getProtos();

    public static abstract class TreeCall
    extends Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            Node node = this.evalAsNode(focus, evalContext);
            return node == null ? Value.empty : new SingleNode(node);
        }

        public Node evalAsNode(Focus focus, EvalContext evalContext) throws XQueryException {
            EventDrivenBuilder eventDrivenBuilder = new EventDrivenBuilder();
            this.evalAsEvents(eventDrivenBuilder, focus, evalContext);
            return eventDrivenBuilder.crop();
        }

        public abstract void evalAsEvents(XMLEventReceiver var1, Focus var2, EvalContext var3) throws XQueryException;
    }

    public static abstract class OptStringCall
    extends Call {
        public abstract String evalAsOptString(Focus var1, EvalContext var2) throws XQueryException;

        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            String string = this.evalAsOptString(focus, evalContext);
            return string == null ? Value.empty : new SingleString(string);
        }

        public String evalAsString(Focus focus, EvalContext evalContext) throws XQueryException {
            String string = this.evalAsOptString(focus, evalContext);
            if (string == null) {
                evalContext.error((Expression)this, "unexpected empty sequence");
            }
            return string;
        }
    }

    public static abstract class StringCall
    extends Call {
        public abstract String evalAsString(Focus var1, EvalContext var2) throws XQueryException;

        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            return new SingleString(this.evalAsString(focus, evalContext));
        }
    }

    public static abstract class OptDoubleCall
    extends Call {
        public abstract double evalAsOptDouble(Focus var1, EvalContext var2) throws XQueryException;

        public double evalAsDouble(Focus focus, EvalContext evalContext) throws XQueryException {
            try {
                return this.evalAsOptDouble(focus, evalContext);
            }
            catch (EmptyException emptyException) {
                evalContext.error((Expression)this, "unexpected empty sequence");
                return 0.0;
            }
        }

        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            try {
                return new SingleDouble(this.evalAsOptDouble(focus, evalContext));
            }
            catch (EmptyException emptyException) {
                return Value.empty;
            }
        }
    }

    public static abstract class DoubleCall
    extends Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            return new SingleDouble(this.evalAsDouble(focus, evalContext));
        }

        public abstract double evalAsDouble(Focus var1, EvalContext var2) throws XQueryException;
    }

    public static abstract class OptFloatCall
    extends Call {
        public abstract float evalAsOptFloat(Focus var1, EvalContext var2) throws XQueryException;

        public float evalAsFloat(Focus focus, EvalContext evalContext) throws XQueryException {
            try {
                return this.evalAsOptFloat(focus, evalContext);
            }
            catch (EmptyException emptyException) {
                evalContext.error((Expression)this, "unexpected empty sequence");
                return 0.0f;
            }
        }

        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            try {
                return new SingleFloat(this.evalAsFloat(focus, evalContext));
            }
            catch (EmptyException emptyException) {
                return Value.empty;
            }
        }
    }

    public static abstract class FloatCall
    extends Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            return new SingleFloat(this.evalAsFloat(focus, evalContext));
        }

        public abstract float evalAsFloat(Focus var1, EvalContext var2) throws XQueryException;
    }

    public static abstract class OptIntegerCall
    extends Call {
        public abstract long evalAsOptInteger(Focus var1, EvalContext var2) throws XQueryException;

        public long evalAsInteger(Focus focus, EvalContext evalContext) throws XQueryException {
            try {
                return this.evalAsOptInteger(focus, evalContext);
            }
            catch (EmptyException emptyException) {
                evalContext.error((Expression)this, "unexpected empty sequence");
                return 0L;
            }
        }

        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            try {
                return new SingleInteger(this.evalAsInteger(focus, evalContext));
            }
            catch (EmptyException emptyException) {
                return Value.empty;
            }
        }
    }

    public static abstract class IntegerCall
    extends Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            return new SingleInteger(this.evalAsInteger(focus, evalContext));
        }

        public abstract long evalAsInteger(Focus var1, EvalContext var2) throws XQueryException;
    }

    public static abstract class BoolCall
    extends Call {
        public abstract boolean evalAsBoolean(Focus var1, EvalContext var2) throws XQueryException;

        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            return new SingleBoolean(this.evalAsBoolean(focus, evalContext));
        }

        public boolean evalAsEffectiveBoolean(Focus focus, EvalContext evalContext) throws XQueryException {
            return this.evalAsBoolean(focus, evalContext);
        }
    }

    public static abstract class Call
    extends Expression {
        public Expression[] args;
        public Prototype prototype;

        public Expression child(int n) {
            return n < this.args.length ? this.args[n] : null;
        }

        public void dump(ExprDump exprDump) {
            exprDump.header(this, "Call " + this.prototype);
            exprDump.display("args", this.args);
        }

        public void compilationHook() {
        }

        public Object objArg(Expression[] expressionArray, int n, Class clazz, Focus focus, EvalContext evalContext) throws XQueryException {
            try {
                Item item = expressionArray[n].evalAsItem(focus, evalContext);
                Object object = null;
                if (!(item instanceof WrappedObjectValue) || !clazz.isAssignableFrom((object = ((WrappedObjectValue)item).getObject()).getClass())) {
                    String string = clazz.getName();
                    evalContext.error((Expression)this, "bad type for argument " + (n + 1) + ": expecting " + string.substring(string.lastIndexOf(46) + 1));
                }
                return object;
            }
            catch (XQueryException xQueryException) {
                evalContext.error(expressionArray[n], new EvalException("error on argument " + (n + 1) + ": " + xQueryException.getMessage(), xQueryException));
                return null;
            }
        }
    }
}

