/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.DefaultWordSifter;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.impl.*;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.dm.*;
import java.util.ArrayList;

/**
 *  Processes a XML fragment and returns it with "highlighted" occurrences of the
 *  terms of a full-text query.
 */
public class XfnHighlighter extends Function
{
    static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "highlighter");
    static Prototype[] protos = { 
        new Prototype(qfname, Type.BOOLEAN.opt, Exec.class)
	.arg("query", Type.STRING)
	.arg("fragment", Type.NODE)
	.arg("parts", Type.NODE.star)
	.arg("options", Type.NODE.opt),
        new Prototype(qfname, Type.BOOLEAN.opt, Exec.class)
	.arg("query", Type.STRING)
	.arg("fragment", Type.NODE)
	.arg("parts", Type.NODE.star)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.TreeCall {

        public void evalAsEvents(XMLEventReceiver output, Focus focus, EvalContext context)
	    throws XQueryException {
            context.at(this);
	    FulltextQuery query = null;
	    try {
		String q = args[0].evalAsString(focus, context);
		query =
		    FulltextQuery.parseQuery(q, XfnFulltext.getWordSifter(context)); 
	    }
	    catch (FulltextQuery.ParseException e) {
		context.error(args[0], "full-text query error: "+e.getMessage());
	    }
	    Node fragment = args[1].evalAsNode(focus, context);
	    Value parts = args[2].eval(focus, context);
	    Node options = (args.length<4)? null : args[3].evalAsOptNode(focus, context);

	    FulltextQuery.Hiliter hiliter = query.new Hiliter();
	    if(options != null) {
		for(Value list = options.getAttributes(); list.next(); ) {
		    Node attr = list.asNode();
		    String option = attr.getNodeName().getLocalName();
		    if(option.equals("attribute"))
			hiliter.attribute = QName.get(attr.getStringValue());
		    else if(option.equals("element"))
			hiliter.element = QName.get(attr.getStringValue());
		    else if(option.equals("prefix"))
			hiliter.pattern = attr.getStringValue();
		}
	    } 
	    try {
		for(; parts != null && parts.next(); )
		    hiliter.addMatchingArea(parts.asNode());
		query.highlight( fragment, hiliter, output ); 
	    }
	    catch (DataModelException e) { }
	}
    }
}
