/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.util.time;

import java.util.Date;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Locale;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

/**
 *	Representation of a DateTime value.
 */
public class DateTime extends DateTimeBase
{
    public DateTime( int year, int month, int day, int hour, int minute, double second,
		     int tzSign, int tzHour, int tzMinute ) throws DateTimeException {
	super( year, month, day, hour, minute, second,
	       tzSign, tzHour, tzMinute );
    }

    public DateTime( DateTimeBase dt ) throws DateTimeException {
	this( dt.year, dt.month, dt.day, dt.hour, dt.minute, dt.second,
	      dt.tzSign, dt.tzHour, dt.tzMinute );
    }

    public DateTime() { }

    public DateTimeBase parse( String that, int implicitTimeZone ) throws DateTimeException {
	return parseDateTime(that, implicitTimeZone);
    }

    /**
     *	Uses implicitTimeZone (minutes) if not specified explictly in the string form.
     */
    public static DateTime parseDateTime(String s, int implicitTimeZone)
	throws DateTimeException {
	int year;
	int month;
	int day;
	int hour;
	int minute;
	double second;
	int[] tz = new int[3];

	int charCount = s.length();
	if (charCount == 0)
	    throw new DateTimeException("invalid syntax", s);

	int pos = 0;
	boolean negativeYear = false;
	if (s.charAt(pos) == '-') {
	    negativeYear = true;
	    ++pos;
	}
	int nextPos = s.indexOf('-', pos);
	if (nextPos < pos+4)
	    throw new DateTimeException("invalid year", s);
	year = parseInt(s, pos, nextPos);
	if (negativeYear)
	    year = -year;
	pos = nextPos + 1;

	if (pos+2 >= charCount || s.charAt(pos+2) != '-')
	    throw new DateTimeException("invalid month", s);
	month = parseInt(s, pos, pos+2);
	pos += 3;

	if (pos+2 >= charCount || s.charAt(pos+2) != 'T')
	    throw new DateTimeException("invalid day", s);
	day = parseInt(s, pos, pos+2);
	pos += 3;

	if (pos+2 >= charCount || s.charAt(pos+2) != ':')
	    throw new DateTimeException("invalid syntax", s);
	hour = parseInt(s, pos, pos+2);
	pos += 3;

	if (pos+2 >= charCount || s.charAt(pos+2) != ':')
	    throw new DateTimeException("invalid syntax", s);
	minute = parseInt(s, pos, pos+2);
	pos += 3;

	nextPos = parseTimeZone(s, pos, tz);
	if (nextPos < pos+2)
	    throw new DateTimeException("invalid syntax", s);

	second = parseDouble(s, pos, nextPos);

	DateTime result =
	    new DateTime(year, month, day, hour, minute, second, tz[0], tz[1], tz[2]);
	if(tz[0] == 0)
	    result.forceTimeZone( implicitTimeZone );
	return result;
    }

    public String toString() {
	StringBuffer buffer = new StringBuffer();

	if (year < 0) {
	    buffer.append('-');
	    appendPadded(-year, 4, buffer);
	} else {
	    appendPadded(year, 4, buffer);
	}
	buffer.append('-');
	appendPadded(month, 2, buffer);
	buffer.append('-');
	appendPadded(day, 2, buffer);

	buffer.append('T');

	appendPadded(hour, 2, buffer);
	buffer.append(':');
	appendPadded(minute, 2, buffer);
	buffer.append(':');
	appendPadded(second, 2, buffer);

	appendTimeZone(tzSign, tzHour, tzMinute, buffer);

	return buffer.toString();
    }

} // end of class DateTime

