/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery;

import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.util.QName;
import java.math.BigDecimal;
import java.text.Collator;

/**
 *	XQuery abstract Item value.
 *	<p>Specialized methods allow to retrieve or convert the actual value according to
 *	the type (return by getType()).
 *	A type exception is raised if the conversion is not possible.
 *	
 */
public interface Item
{
    /**
     *	Returns the type description.
     */
    ItemType getType();

    /**
     *	Gets the item as a boolean value (optimisable).
     */
    boolean  asBoolean() throws TypeException;

    /**
     *	Gets the item as a float value (optimisable).
     */
    float    asFloat() throws TypeException;

    /**
     *	Gets the item as a double value (optimisable).
     */
    double   asDouble() throws TypeException;

    /**
     *	Gets the item as a integer value (optimisable).
     */
    long     asInteger() throws TypeException;

    /**
     *	Gets the item as a decimal value.
     */
    BigDecimal  asDecimal() throws TypeException;

    /**
     *	Gets the item as a String value (optimisable).
     */
    String   asString() throws TypeException;

    /**
     *	Gets the item as a Node value (optimisable).
     */
    Node   asNode() throws TypeException;

    /**
     *	Tests whether the item is a Node.
     */
    boolean  isNode();

    /**
     *	Compares two items.
     *  if items are equal, returns 0,
     *  if no order is defined, or items are of different nature, returns INCOMPARABLE,
     *  if this < that return -1,
     *  if this > that return 1.
     */
    int compareTo(Item that, Collator collator, int implicitTimeZone) throws TypeException;
    int INCOMPARABLE = 2;

    /**
     *	Deep equality of two items.
     */
    boolean deepEqual( Item item, Collator collator );

} // end of interface Item

