/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.time.*;
import net.xfra.qizxopen.xquery.*;

public class DurationType extends AtomicType {

    public String getShortName() {
        return "duration";
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
	ItemType type = value.getType();
	Duration result = null;
	try {
	    if(type instanceof StringType)
		result = Duration.parseDuration( value.asString() );
	    else if(type instanceof DurationType)
		result = ((DurationValue) value.asItem()).getValue();
	    else throw new DateTimeException("invalid type "+type);
	} catch (DateTimeException e) {
	    throw new TypeException("cannot cast to xs:duration : "+ e.getMessage());
        }
	return new SingleDuration( result, Type.DURATION );
    }
}
