/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;

public class ShortType extends IntType {

    public String getShortName() {
        return "short";
    }

    protected long upperBound() {
	return Short.MAX_VALUE;
    }
    protected long lowerBound() {
	return Short.MIN_VALUE;
    }

    public Value  convertFromObject( Object object ) {
	return new SingleInteger( ((Short) object).shortValue(), Type.SHORT );
    }

    public Object convertToObject( Expression expr, Focus focus, EvalContext context )
	throws XQueryException {
	return new Short( (short) expr.evalAsInteger(focus, context));
    }

    public Value  convertFromArray( Object object ) {
	short[] result = (short[]) object;
	return new IntegerArraySequence(result, result.length);
    }

    public Object convertToArray( Value value ) throws XQueryException {
	return IntegerArraySequence.expandShorts( value );
    }
}
