/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;

public class StringType extends AtomicType {

    public String getShortName() {
        return "string";
    }

    protected boolean checkValue( String value ) {
	return true;
    }

    public Value cast( Value value, EvalContext context ) throws TypeException {
	ItemType type = value.getType();
	String result = null;
	try {
	    result = value.asString();
	} catch (TypeException e) {
	    throw new TypeException("cannot cast to xs:string: "+ e.getMessage());
        }
	if( !checkValue(result) )
	    throw new TypeException("cannot cast to xs:"+ getShortName() +
				    ": value does not conform to facets");
	return new SingleString( result, this );
    }

    public Value  convertFromObject( Object object ) {
	return (object == null)? Value.empty : new SingleString(object.toString());
    }

    public Object convertToObject( Expression expr, Focus focus, EvalContext context )
	throws XQueryException {
	return expr.evalAsString(focus, context);
    }

    public Value  convertFromArray( Object object ) {
	String[] result = (String[]) object;
	return new StringArraySequence(result, result.length);
    }

    public Object convertToArray( Value value ) throws XQueryException {
	return StringArraySequence.expand( value );
    }
}
