/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.*;
import java.text.Collator;

/**
 *	Base class for Wrapped Java Object.
 */
public abstract class WrappedObjectValue extends BaseValue
{
    public WrappedObjectValue() {
	itemType = Type.WRAPPED_OBJECT;
    }

    public abstract Object getObject();

    public Item  asItem() throws TypeException {
	return this;
    }

    public String  asString() throws TypeException {
	return getObject().toString();
    }

    public boolean  asBoolean() throws TypeException {
	String d = asString();
	return d.length() != 0;	
    }

    public long   asInteger() throws TypeException {
	return Conversion.toInteger( asString() ); 
    }

    public double asDouble() throws TypeException {
	return Conversion.toDouble( asString() ); 
    }

    public boolean equals( Object that ) {
	if(! (that instanceof WrappedObjectValue) )
	    return false;
	return getObject().equals( ((WrappedObjectValue) that).getObject() );
    }

    public int hashCode() {
	return getObject().hashCode();
    }

    public int compareTo( Item that, Collator c, int implicitTimeZone ) {
	return INCOMPARABLE;
    }
} // end of class WrappedObjectValue

