/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.impl.*;

/**
 *  Implementation of function fn:node-kind.
 */
public class NodeKind extends Function {

    static Prototype[] protos = { 
        Prototype.fn("node-kind", Type.STRING, Exec.class)
            .arg("srcval", Type.NODE.star)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.StringCall {

        public String evalAsString(Focus focus, EvalContext context) throws XQueryException {
            context.at(this);
	    Node node = args[0].evalAsNode(focus, context);
	    return node.getNodeKind();
        }
    }
}
