/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.dt.StringValue;
import java.util.regex.*;

/**
 *  Implementation of function fn:tokenize.
 */
public class Tokenize extends Matches {

    static Prototype[] protos = { 
        Prototype.fn("tokenize", Type.STRING.star, Exec.class)
            .arg("input", Type.STRING.opt)
            .arg("pattern", Type.STRING),
        Prototype.fn("tokenize", Type.STRING.star, Exec.class)
            .arg("input", Type.STRING.opt)
            .arg("pattern", Type.STRING)
            .arg("flags", Type.STRING)
    };

    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.Call {

	Pattern precompiled;
	// precompile regexp if constant
	public void compilationHook() {
	    Expression xflags = args.length < 3 ? null : args[2];
	    precompiled = precompileRegexp(args[1], xflags, false);
	}

        public Value eval(Focus focus, EvalContext context) throws XQueryException {
	    String input = args[0].evalAsOptString(focus, context);
	    if(input == null)
		return Value.empty;
            context.at(this);

	    Expression xflags = args.length < 3 ? null : args[2];
	    Pattern pat = precompiled != null ? 
		precompiled : compileRegexp(args[1], xflags, false, focus, context);

	    return new Sequence( input, pat);
        }
    }

    static class Sequence extends StringValue {

	String source, current;
	Pattern regexp;
	Matcher matcher;
	int lastStop = 0;	// where the last match ends

	Sequence( String source, Pattern regexp ) {
	    this.source = source;
	    this.regexp = regexp;
	    matcher = regexp.matcher(source);
	}

	public boolean next() throws XQueryException {
	    if(lastStop < 0)	// there was no match at end
		return false;
	    if(!matcher.find()) {
		current = source.substring(lastStop);
		lastStop = -1; // means no match at end
	    }
	    else {
		current = source.substring(lastStop, matcher.start());
		lastStop = matcher.end(); // can be source.length() -> empty token
	    }
	    return true;
	}

	public String  asString() throws TypeException {
	    return current;
	}

	public Value  bornAgain() {
	    return new Sequence(source, regexp);
	}
    }
    
}
