/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */


package net.xfra.qizxopen.xquery.fn;
import net.xfra.qizxopen.xquery.impl.*;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;

/**
 *  Implementation of function xs:double.
 */
public class XS_double extends Function {

    static Prototype[] protos = { 
        Prototype.xs("double", Type.DOUBLE, Exec.class) .arg("srcval", Type.ANY_ATOMIC_TYPE)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Function.DoubleCall {

	public double evalAsDouble( Focus focus, EvalContext context ) throws XQueryException {
	    try {
		return args[0].evalAsDouble(focus, context);
	    }
	    catch (TypeException err) {
		err = new TypeException("cannot cast to double: "+err.getMessage());
		err.setContext(context);
		throw err;
	    }
	}
    }
}
