/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.impl.SequenceType;
import java.util.Vector;

/**
 *	Implementation of operator 'cast as'.
 */
public class CastExpr extends Expression {

    public Expression expr;
    public ItemType   targetType;
    protected boolean isOptional;

    public CastExpr( Expression expr, Type targetType ) {
        this.expr = expr;
        this.targetType = targetType.getItemType();
	isOptional = targetType instanceof SequenceType;  // can be only << itemType? >>
    }

    public Expression child(int rank) {
	return (rank == 0)? expr : null;
    }

    public void dump( ExprDump d ) {
	d.header( this, "cast as" );
        d.display("type", targetType);
        d.display("expr", expr);
    }

    public Expression staticCheck( StaticContext context ) {	
	expr = context.staticCheck( expr, 0 );
        type = targetType;
	return this;
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	Value v = expr.eval(focus, context), result;
	if(!v.next()) {
	    if(!isOptional)
		context.error(this, "empty sequence cannot be cast to type "+ targetType);
	    else return Value.empty;
	}
        try {
	    result = targetType.cast(v, context);
        }
        catch (TypeException err) {
	    err.setContext(context);
	    throw err;
        }
	if(v.next())
	    context.error(this, "singleton expected in cast");
	return result;
    }
}
