/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dt.SingleInteger;

/**
 *  Enumerates the items of a single Flower 'for' clause and manages the associated variables.
 */
public class ForClause extends VarClause {

    public QName  position;
    public LocalVariable  posDecl;

    public ForClause( QName variable ) {
        super( variable );
    }

    public void dump( ExprDump d ) {
	d.header( this, "For" );
        d.display("variable", "$"+ variable+" : "+ varType+
		  (d.pretty()? "" : (" addr "+varDecl.address)));
	if(position != null) {
	    d.display("position", position+" addr "+posDecl.address);
	}
        d.display("expr", expr);
    }
    
    public Expression staticCheck( StaticContext context ) {
	if(checked)
	    return this;	// because of the insertion of a let before it
	checked = true;
	expr = context.staticCheck( expr, 0 );
	type = varType;
	if(varType == null)
	    varType = expr.getType().getItemType();
	else {
	    ItemType actualVarType = expr.getType().getItemType();
	    if( !varType.accepts(actualVarType) ) {
		context.error( this,
			       "incompatible value type %2 for variable %1",
			       context.prefixedName(variable),
			       actualVarType.toString(context));
	    }
	}
	varDecl = context.defineLocalVariable(variable, varType, this);

 	if(position != null)
 	    posDecl = context.defineLocalVariable(position, Type.INTEGER, this);
	return this;
    }

    public Value eval(Focus focus, EvalContext context) throws XQueryException {
	return new Sequence( focus, context );
    }

    public class Sequence extends VarClause.Sequence
    {
	Value  current;	// evaluated expression
	int    curPos;

	Sequence( Focus focus, EvalContext context ) {
	    super(focus, context);
	    current = Sequence.empty;
	}

	public boolean next() throws XQueryException {
	    for (;;) {
		if(current.next()) {
		    try {
			context.storeLocal( varDecl.address, current, true );
		    } catch(TypeException err) {
			context.error( ForClause.this,
				       "dynamic type mismatch on 'for' variable: "
				       + err.getMessage() + ", expecting "+ varType);
		    }
		    ++ curPos;
		    if(position != null)
			context.storeLocalInteger( posDecl.address, curPos );
		    return true;
		}
		if(!source.next())
		    return false;
		current = expr.eval( focus, context );
		curPos = 0;
	    }
	}

	public boolean nextCollection() throws XQueryException {
	    for (;;) {
		if(current.nextCollection()) {
		    try {
			context.storeLocal( varDecl.address, current, true );
		    } catch(TypeException err) {
			context.error( ForClause.this,
				       "dynamic type mismatch on 'for' variable: "
				       + err.getMessage() + ", expecting "+ varType);
		    }
		    ++ curPos;
		    if(position != null)
			context.storeLocalInteger( posDecl.address, curPos );
		    return true;
		}
		if(!source.next())
		    return false;
		current = expr.eval( focus, context );
		curPos = 0;
	    }
	}

	public Value  bornAgain() {
	    Sequence s = new Sequence( focus, context );
	    s.setSource(source.bornAgain());
	    return s;
	}
    }
}
