/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.fn.Prototype;

/**
 * Comparison on sequences.
 */
public abstract class GeneralComparison extends Comparison {

    public GeneralComparison( Expression expr1, Expression expr2 ) {
        super(expr1, expr2);
    }

    static Prototype[] protos = { 
        Prototype.op("general-comparison", Type.BOOLEAN, Exec.class)
            .arg("op1", Type.ITEM.star).arg("op2", Type.ITEM.star)
    };
    public Prototype[] getProtos() { return protos; }

    public static class Exec extends Comparison.Exec {

	public void dump( ExprDump d ) {
	    d.header( this, "general "+ test.getName());
	    d.display("left", args[0]); d.display("right", args[1]);
	}

	public boolean evalAsBoolean( Focus focus, EvalContext context )
	    throws XQueryException {
	    Value v1 = args[0].eval(focus, context);
	    Value v2 = args[1].eval(focus, context);
	    context.at(this);
	    boolean first = true;
	    for( ; v1.next() ; ) {
		if(!first)
		    v2 = v2.bornAgain();
		first = false;
		for( ; v2.next() ; ) {
		    try {
			int cmp = v1.compareTo( v2.asItem(), context.getCollator(null),
						context.getImplicitTimezone() );
			if(Math.abs(cmp) == Item.INCOMPARABLE)
			    context.error(this, "values are not comparable ("+ v1.getType()
					  +" and "+ v2.getType() +")");
			if( test.make(cmp) )
			    return true;
		    }
		    catch (TypeException e) {
			// semantics: ??
			context.error(this, e);
		    }
		}
	    }	
	    return false;
	}
    }

}
