/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;

/**
 *  class InstanceofExpr: 
 * 
 */
public class InstanceofExpr extends CastableExpr {

    public InstanceofExpr( Expression expr, Type targetType ) {
        super(expr, targetType);
    }

    public void dump( ExprDump d ) {
	d.header( this, "InstanceofExpr" );
        d.display("expr", expr);
        d.display("targetType", targetType);
    }

    public boolean evalAsBoolean( Focus focus, EvalContext context ) throws XQueryException {
	return targetType.test( expr.eval(focus, context) );
    }
}
