/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;

/**
 *	Local variable declaration.
 */
public class LocalVariable extends LeafExpression
{
    public QName name;
    public int address;
    // expression that declares the variable (formal optimisations)
    public Expression owner;

    // managed as a tree:
    // - sibling nodes are allocated the same address (if same storage type)
    //   order of siblings is not relevant
    // - var2 down var1 is used at the same time
    public LocalVariable before;
    public LocalVariable after;
    public LocalVariable replacer;	// or replaced by

    public LocalVariable(QName name, Type type, Expression owner) {
        this.name = name;
	this.type = type;
	this.owner = owner;
    }

    public void addAfter( LocalVariable var ) {
	var.replacer = this.after;	// null in general
	this.after = var;
	var.before = this;
    }

    public void removeAfter( LocalVariable var ) {
	if(after == var)
	    after = var.replacer;
	else for(LocalVariable slot = after; slot != null; slot = slot.replacer)
	    if(slot.replacer == var) {
		slot.replacer = var.replacer;
		break;
	    }
	var.replacer = null;
    }

    // declare this variable just before 'var'
    // in terms of tree operations, this is equivalent to wrap var inside this var.
    public void declareBefore( LocalVariable var ) {
	// disconnect 'var':
	LocalVariable previous = var.before;
	previous.removeAfter(var);
	// insert this as child of previous:
	previous.addAfter(this);
	// and 'var' as child of this:
	this.addAfter(var);
    }

    public void defineType(Type type) {
	this.type = type;
	// if can be allocated in a register, disable upper variables in excess
	int registerMax = EvalContext.MAX_REGISTER;
	if( type.getOccurrence() == Type.ONE_OCC) {
	    if(type != Type.INTEGER && type != Type.DOUBLE &&
	       type != Type.STRING) {
		// item registers: different count
		registerMax =
		    EvalContext.LAST_REGISTER - EvalContext.ITEM_REGISTER;
		type = Type.ITEM;	/// CAUTION
	    }
	    for(LocalVariable prev=this.before; prev != null; prev= prev.before)
		if(prev.getType() == type) {
		    -- registerMax;
		    if(registerMax <= 0) {
			prev.address = -1;  // non register
		    }
		}
	}
    }
} // end of class LocalVariable
