/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import java.text.Collator;

/**
 *  Stores the information for one 'order by' clause.
 */
public class OrderSpec extends Expression {

    public Expression  key;
    public String  collation;
    private Collator collator;
    public boolean descending = false;
    public boolean emptyGreatest = false;

    public OrderSpec( Expression key ) {
        this.key = key;
    }

    public Expression child(int rank) {
	return (rank == 0)? key : null;
    }

    public void dump( ExprDump d ) {
	d.header( this,"OrderSpec" );
        d.display("key", key);
        d.display("descending", ""+descending);
        d.display("emptyGreatest", ""+emptyGreatest);
        d.display("collation", collation);
    }

    public Expression staticCheck( StaticContext context ) {
	key = context.staticCheck( key, 0 );
	type = key.getType();
	collator = context.getCollator(collation);
	return this;
    }

    // null key means empty
    int compare( Item key1, Item key2, int implicitTimeZone ) throws TypeException {
	int cmp = 0;
	if(key1 == null)
	    cmp = (key2 == null) ? 0 : emptyGreatest ? 1 : -1;
	else if(key2 == null)
	    cmp = emptyGreatest ? -1 : 1;
	else
	    cmp = key1.compareTo(key2, collator, implicitTimeZone);
	//TODO: deal with NaN
	return descending? -cmp : cmp;
    }
}
