/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import java.util.Vector;

/**
 *  class ParentStep: 
 * 
 */
public class ParentStep extends BasicStep {

    public ParentStep( NodeTest nodeTest ) {
        super( nodeTest );
    }

    public void dump( ExprDump d ) {
	d.header( this, "ParentStep" );
        d.display("nodeTest", nodeTest == null ? null : nodeTest.toString());
    }

    public int getFlags() {
	return DOCUMENT_ORDER + SAME_DEPTH;
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	checkFocus(focus, context);
	return focus.getItem().asNode().getParent( nodeTest );
    }
}
