/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.dm.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;
import net.xfra.qizxopen.xquery.dt.ArraySequence;
import java.util.Vector;

/**
 *  class TypeswitchExpr: 
 * 
 */
public class TypeswitchExpr extends Expression {

    public Expression  switche;
    CaseClause[] caseClauses;

    public TypeswitchExpr( Expression on ) {
        this.switche = on;
    }

    public void  addCaseClause( CaseClause clause ) {
        if( caseClauses == null)
	    caseClauses = new CaseClause[] { clause };
	else{
            CaseClause[] old = caseClauses;
            caseClauses = new CaseClause[ old.length + 1 ];
            System.arraycopy(old, 0, caseClauses, 0, old.length);
	    caseClauses[old.length] = clause;
        }
    }

    CaseClause  getCaseClause( int rank ) {
        return rank < 0 || rank >= caseClauses.length ? null : caseClauses[rank];
    }


    public Expression child(int rank) {
	return (rank == 0)? switche 
	     : (rank <= caseClauses.length)? caseClauses[rank-1] : null;
    }

    public void dump( ExprDump d ) {
	d.header( this, "TypeswitchExpr" );
        d.display("on", switche);
        d.display("caseClauses", caseClauses);
    }

    public Expression staticCheck( StaticContext context ) {
	switche = context.staticCheck( switche, 0 );
	type = null;
	for(int c = 0, C = caseClauses.length; c < C; c++) {
	    context.staticCheck( caseClauses[c], 0 );
	    if(type == null)
		type = caseClauses[c].getType();
	    else
		type = type.unionWith( caseClauses[c].getType() );
	}
	//TODO: detect switch on single item -> optimizable
	//TODO: optimize by hashing, grouping by kind etc...
	return this;
    }

    public Value eval( Focus focus, EvalContext context ) throws XQueryException {
	Value value = switche.eval(focus, context);
	context.at(this);
	ArraySequence seq = new ArraySequence(8);
	for( ; value.next(); )
	    seq.addItem( value.asItem() );
	seq.pack();
	// brute force implementation: TODO
	for(int c = 0, C = caseClauses.length; c < C; c++) {
	    CaseClause cc = caseClauses[c];
	    seq.reset();
	    if(cc.varType.test(seq)) {
		seq.reset();
		if(cc.variable != null)
		    context.storeLocal(cc.varDecl.address, seq, false/*current*/);
		return cc.expr.eval(focus, context);
	    }
	}
        throw new RuntimeException("Typeswitch default failed"); // should not happen
    }

    public void evalAsEvents( XMLEventReceiver output, Focus focus, EvalContext context )
	throws XQueryException, DataModelException  {
	Value value = switche.eval(focus, context);
	context.at(this);
	ArraySequence seq = new ArraySequence(8);
	for( ; value.next(); )
	    seq.addItem( value.asItem() );
	seq.pack();
	// brute force implementation: TODO
	for(int c = 0, C = caseClauses.length; c < C; c++) {
	    CaseClause cc = caseClauses[c];
	    seq.reset();
	    if(cc.varType.test(seq)) {
		seq.reset();
		if(cc.variable != null)
		    context.storeLocal(cc.varDecl.address, seq, false/*current*/);
		cc.expr.evalAsEvents( output, focus, context );
		break;
	    }
	}
    }
}
