/*
 *	Qizx/Open version 0.4
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.*;
import net.xfra.qizxopen.xquery.*;
import net.xfra.qizxopen.xquery.dm.*;

/**
 *  class ValidateExpr: 
 * 
 */
public class ValidateExpr extends Expression {

    public final static int LAX_MODE = 1, STRICT_MODE = 2, SKIP_MODE = 3;
    public Expression  schemaContext;
    public Expression  expr;
    public int mode;

    public ValidateExpr( int mode, Expression schemaContext, Expression expr ) {
	this.mode = mode;
        this.schemaContext = schemaContext;
        this.expr = expr;
    }

    public Expression child(int rank) {
	return rank == 0 ? expr : null;
    }

    public void dump( ExprDump d ) {
	d.header( this, "ValidateExpr" );
        d.display("mode", ""+mode);
        d.display("schemaContext", schemaContext);
        d.display("expr", expr);
    }

    public Expression staticCheck( StaticContext context ) {
	context.error(this, "validate is not supported", null, null);
	type = Type.NODE.star;
	return this;
    }

    public Value eval(Focus focus, EvalContext context) throws XQueryException {
        throw new RuntimeException("ValidateExpr not implemented");
    }
}
