/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.QizxException;
import com.qizx.api.XMLPushStream;
import com.qizx.api.fulltext.TextTokenizer;
import com.qizx.api.util.fulltext.DefaultTextTokenizer;
import com.qizx.api.util.text.FormatDateSieve;
import com.qizx.api.util.text.FormatNumberSieve;
import com.qizx.api.util.text.ISODateSieve;
import com.qizx.util.NamespaceContext;
import com.qizx.util.basic.Check;
import com.qizx.util.basic.Util;
import com.qizx.xdm.DataConversion;
import com.qizx.xdm.DocumentParser;
import com.qizx.xdm.IQName;
import java.beans.Beans;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Indexing
implements DataConversion {
    public static final byte STRING = 1;
    public static final byte NUMERIC = 2;
    public static final byte NUMERIC_AND_STRING = 3;
    public static final byte DATE = 4;
    public static final byte DATE_AND_STRING = 5;
    public static final byte INHERIT = 0;
    public static final byte DISABLE_FULL_TEXT = -1;
    public static final byte ENABLE_FULL_TEXT = 1;
    private static final QName INDEXING_ELEM = IQName.get("indexing");
    private static final QName ELEMENT_RULE = IQName.get("element");
    private static final QName ATTRIBUTE_RULE = IQName.get("attribute");
    private static final QName WORD_SIEVE = IQName.get("word-sieve");
    private static final QName WORD_MIN = IQName.get("word-min");
    private static final QName WORD_MAX = IQName.get("word-max");
    private static final QName STRING_MAX = IQName.get("string-max");
    private static final QName NAME = IQName.get("name");
    private static final QName CONTEXT = IQName.get("context");
    private static final QName FULLTEXT = IQName.get("full-text");
    private static final QName ATTR_FULLTEXT = IQName.get("attr-full-text");
    private static final QName AS = IQName.get("as");
    private static final QName SIEVE = IQName.get("sieve");
    private static final int DEFAULT_STRING_MAX = 50;
    private static final String[] INDEXING_TYPES = new String[]{null, "STRING", "NUMERIC", "NUMERIC+STRING", "DATE", "DATE+STRING", "NUMBER", "NUMBER+STRING"};
    private static final byte[] INDEXING_CODES = new byte[]{0, 1, 2, 3, 4, 5, 2, 3};
    private static final String DEFAULT_WORDSIEVE_PACKAGE = DefaultTextTokenizer.class.getPackage().getName();
    private static final String DEFAULT_SIEVE_PACKAGE = FormatNumberSieve.class.getPackage().getName();
    private int maxStringLength = 50;
    private int maxWordLength = 30;
    private int minWordLength = 1;
    private boolean fulltext = true;
    private boolean attrFulltext = false;
    private ArrayList<Rule> elementRules;
    private ArrayList<Rule> attributeRules;
    private NamespaceContext namespaces = new NamespaceContext();
    private int ruleRank;
    private HashMap<QName, ArrayList<Rule>> fastElemMap;
    private HashMap<QName, ArrayList<Rule>> fastAttrMap;
    private static final QName DEF = IQName.get("*");

    public Indexing() {
        this.elementRules = new ArrayList();
        this.attributeRules = new ArrayList();
    }

    public static Indexing defaultRules() {
        Indexing indexing = new Indexing();
        indexing.addDefaultElementRule(null, 5);
        indexing.addDefaultElementRule(null, 3);
        indexing.addDefaultElementRule(null, 1);
        indexing.addDefaultAttributeRule(null, 5);
        indexing.addDefaultAttributeRule(null, 3);
        indexing.addDefaultAttributeRule(null, 1);
        return indexing;
    }

    public void parse(InputSource inputSource) throws QizxException {
        Check.nonNull(inputSource, "source");
        try {
            this.parse(DocumentParser.parse(inputSource));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new QizxException("parse error: " + exception.getMessage(), exception);
        }
    }

    public void parse(InputSource inputSource, XMLReader xMLReader) throws QizxException {
        try {
            Check.nonNull(inputSource, "source");
            this.parse(DocumentParser.parse(inputSource, xMLReader));
        }
        catch (Exception exception) {
            throw new QizxException("parse error: " + exception.getMessage(), exception);
        }
    }

    public void parse(Node node) throws DataModelException {
        Object object;
        Object object2;
        Check.nonNull(node, "specification");
        this.ruleRank = 0;
        if (node.getNodeNature() == 1) {
            for (object2 = node.getFirstChild(); object2 != null && object2.getNodeNature() != 2; object2 = object2.getNextSibling()) {
            }
            node = object2;
        }
        if (node == null || node.getNodeName() != INDEXING_ELEM) {
            this.error("'indexing' element expected");
        }
        if ((object2 = node.getAttributes()) != null) {
            int n = ((Node[])object2).length;
            for (int i = 0; i < n; ++i) {
                object = object2[i].getNodeName();
                if (object == WORD_MIN) {
                    this.minWordLength = this.integerProp(object2[i]);
                    continue;
                }
                if (object == WORD_MAX) {
                    this.maxWordLength = this.integerProp(object2[i]);
                    continue;
                }
                if (object == STRING_MAX) {
                    this.maxStringLength = this.integerProp(object2[i]);
                    continue;
                }
                if (object == FULLTEXT) {
                    this.fulltext = this.booleanProp(object2[i]);
                    continue;
                }
                if (object == ATTR_FULLTEXT) {
                    this.attrFulltext = this.booleanProp(object2[i]);
                    continue;
                }
                if (object == WORD_SIEVE) continue;
                this.error("unknown property: " + object);
            }
        }
        this.ruleRank = 1;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            QName qName = node2.getNodeName();
            if (qName == null) continue;
            if (qName == ELEMENT_RULE) {
                object = this.parseRule(node2);
                this.elementRules.add((Rule)object);
            } else if (qName == ATTRIBUTE_RULE) {
                object = this.parseRule(node2);
                this.attributeRules.add((Rule)object);
            } else {
                this.error("invalid rule " + this.ruleRank + ": " + qName + ": 'element' or 'attribute' expected");
            }
            ++this.ruleRank;
        }
    }

    public void export(XMLPushStream xMLPushStream) throws DataModelException {
        int n;
        Check.nonNull(xMLPushStream, "writer");
        xMLPushStream.putDocumentStart();
        xMLPushStream.putElementStart(INDEXING_ELEM);
        int n2 = this.elementRules.size();
        for (n = 0; n < n2; ++n) {
            this.ruleNamespaces(this.getElementRule(n));
        }
        n2 = this.attributeRules.size();
        for (n = 0; n < n2; ++n) {
            this.ruleNamespaces(this.getAttributeRule(n));
        }
        n2 = this.namespaces.getLocalSize();
        for (n = 0; n < n2; ++n) {
            xMLPushStream.putNamespace(this.namespaces.getLocalPrefix(n), this.namespaces.getLocalNamespaceURI(n));
        }
        xMLPushStream.putAttribute(WORD_MIN, "" + this.minWordLength, null);
        xMLPushStream.putAttribute(WORD_MAX, "" + this.maxWordLength, null);
        xMLPushStream.putAttribute(STRING_MAX, "" + this.maxStringLength, null);
        if (!this.fulltext) {
            xMLPushStream.putAttribute(FULLTEXT, "no", null);
        }
        n2 = this.elementRules.size();
        for (n = 0; n < n2; ++n) {
            this.exportRule(xMLPushStream, ELEMENT_RULE, this.getElementRule(n));
        }
        n2 = this.attributeRules.size();
        for (n = 0; n < n2; ++n) {
            this.exportRule(xMLPushStream, ATTRIBUTE_RULE, this.getAttributeRule(n));
        }
        xMLPushStream.putElementEnd(INDEXING_ELEM);
        xMLPushStream.putDocumentEnd();
    }

    private void exportRule(XMLPushStream xMLPushStream, QName qName, Rule rule) throws DataModelException {
        Serializable serializable;
        xMLPushStream.putElementStart(qName);
        if (rule.name != null) {
            xMLPushStream.putAttribute(NAME, this.exportName(rule.name), null);
        }
        xMLPushStream.putAttribute(AS, INDEXING_TYPES[rule.getIndexingType()], null);
        QName[] qNameArray = rule.getContext();
        if (qNameArray != null) {
            serializable = new StringBuffer(10 * qNameArray.length);
            for (int i = 0; i < qNameArray.length; ++i) {
                if (i > 0) {
                    ((StringBuffer)serializable).append('/');
                }
                ((StringBuffer)serializable).append(this.exportName(qNameArray[i]));
            }
            xMLPushStream.putAttribute(CONTEXT, ((StringBuffer)serializable).toString(), null);
        }
        if (rule.fullText != 0) {
            xMLPushStream.putAttribute(FULLTEXT, rule.fullText == 1 ? "yes" : "no", null);
        }
        if (rule.sieve != null) {
            String[] stringArray;
            serializable = rule.sieve.getClass();
            String string = Util.stringAfter(((Class)serializable).getName(), "com.qizx.api.util.text.");
            if (serializable == ISODateSieve.class && (rule.indexingType == 4 || rule.indexingType == 5)) {
                string = null;
            }
            if (serializable == FormatNumberSieve.class && (rule.indexingType == 2 || rule.indexingType == 3)) {
                string = null;
            }
            if (string != null) {
                xMLPushStream.putAttribute(SIEVE, string, null);
            }
            if ((stringArray = rule.sieve.getParameters()) != null) {
                for (int i = 0; i < stringArray.length; i += 2) {
                    String string2 = stringArray[i];
                    String string3 = stringArray[i + 1];
                    xMLPushStream.putAttribute(IQName.get(string2), string3, null);
                }
            }
        }
        xMLPushStream.putElementEnd(qName);
    }

    private void ruleNamespaces(Rule rule) {
        QName[] qNameArray;
        if (rule.name != null) {
            this.checkName(rule.name);
        }
        if ((qNameArray = rule.getContext()) != null) {
            for (int i = 0; i < qNameArray.length; ++i) {
                this.checkName(qNameArray[i]);
            }
        }
    }

    private void checkName(QName qName) {
        String string;
        String string2 = qName.getNamespaceURI();
        String string3 = string = string2.length() == 0 ? "" : this.namespaces.getPrefix(string2);
        if (string == null) {
            int n = 1;
            while (this.namespaces.getNamespaceURI("ns" + n) != null) {
                ++n;
            }
            this.namespaces.addMapping("ns" + n, string2);
        }
    }

    private String exportName(QName qName) {
        return this.namespaces.prefixedName(qName);
    }

    public Rule addElementRule(QName qName, QName[] qNameArray, int n) {
        Rule rule = new Rule(qName, qNameArray, n);
        rule.setDefaultSieve();
        this.elementRules.add(rule);
        return rule;
    }

    public Rule addDefaultElementRule(QName[] qNameArray, int n) {
        return this.addElementRule(null, qNameArray, n);
    }

    public int getElementRuleCount() {
        return this.elementRules.size();
    }

    public Rule getElementRule(int n) {
        return n < 0 || n >= this.elementRules.size() ? null : this.elementRules.get(n);
    }

    public Rule addAttributeRule(QName qName, QName[] qNameArray, int n) {
        Rule rule = new Rule(qName, qNameArray, n);
        rule.fullText = (byte)-1;
        rule.setDefaultSieve();
        this.attributeRules.add(rule);
        return rule;
    }

    public Rule addDefaultAttributeRule(QName[] qNameArray, int n) {
        return this.addAttributeRule(null, qNameArray, n);
    }

    public int getAttributeRuleCount() {
        return this.attributeRules.size();
    }

    public Rule getAttributeRule(int n) {
        return n < 0 || n >= this.attributeRules.size() ? null : this.attributeRules.get(n);
    }

    public WordSieve getWordSieve() {
        return null;
    }

    public void setWordSieve(WordSieve wordSieve) {
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int n) {
        this.maxStringLength = n;
    }

    public int getMaxWordLength() {
        return this.maxWordLength;
    }

    public void setMaxWordLength(int n) {
        this.maxWordLength = n;
    }

    public int getMinWordLength() {
        return this.minWordLength;
    }

    public void setMinWordLength(int n) {
        this.minWordLength = n;
    }

    public boolean isFulltextEnabled() {
        return this.fulltext;
    }

    public void setFulltextEnabled(boolean bl) {
        this.fulltext = bl;
    }

    public DateSieve addDateSieve(String string, Locale locale, QName qName, QName[] qNameArray) {
        Rule rule = this.addElementRule(qName, qNameArray, 5);
        FormatDateSieve formatDateSieve = new FormatDateSieve();
        formatDateSieve.setFormat(string, locale);
        rule.setSieve(formatDateSieve);
        return formatDateSieve;
    }

    public FormatDateSieve addAttrDateSieve(String string, Locale locale, QName qName, QName[] qNameArray) {
        Rule rule = this.addAttributeRule(qName, qNameArray, 5);
        FormatDateSieve formatDateSieve = new FormatDateSieve();
        formatDateSieve.setFormat(string, locale);
        rule.setSieve(formatDateSieve);
        return formatDateSieve;
    }

    public FormatNumberSieve addNumberSieve(String string, Locale locale, QName qName, QName[] qNameArray) {
        Rule rule = this.addElementRule(qName, qNameArray, 3);
        FormatNumberSieve formatNumberSieve = new FormatNumberSieve();
        formatNumberSieve.setFormat(string, locale);
        rule.setSieve(formatNumberSieve);
        return formatNumberSieve;
    }

    public FormatNumberSieve addAttrNumberSieve(String string, Locale locale, QName qName, QName[] qNameArray) {
        Rule rule = this.addAttributeRule(qName, qNameArray, 3);
        FormatNumberSieve formatNumberSieve = new FormatNumberSieve();
        formatNumberSieve.setFormat(string, locale);
        rule.setSieve(formatNumberSieve);
        return formatNumberSieve;
    }

    @Override
    public double convertNumber(Node node) {
        if (this.fastElemMap == null) {
            this.compileForNodeMatching();
        }
        try {
            String string = node.getStringValue();
            ArrayList<Rule> arrayList = this.getRules(node);
            if (arrayList != null) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    double d;
                    Rule rule = this.ruleAt(i, arrayList);
                    if (rule.indexingType != 2 && rule.indexingType != 3 || !this.contextMatch(rule.context, node) || (d = rule.sieve.convert(string)) != d) continue;
                    return d;
                }
            }
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
        return Double.NaN;
    }

    @Override
    public double convertDate(Node node) {
        if (this.fastElemMap == null) {
            this.compileForNodeMatching();
        }
        try {
            String string = node.getStringValue();
            ArrayList<Rule> arrayList = this.getRules(node);
            if (arrayList != null) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    double d;
                    Rule rule = this.ruleAt(i, arrayList);
                    if (rule.indexingType != 4 && rule.indexingType != 5 || !this.contextMatch(rule.context, node) || (d = rule.sieve.convert(string)) != d) continue;
                    return d;
                }
            }
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
        return Double.NaN;
    }

    private ArrayList<Rule> getRules(Node node) throws DataModelException {
        QName qName = node.getNodeName();
        HashMap<QName, ArrayList<Rule>> hashMap = node.isElement() ? this.fastElemMap : this.fastAttrMap;
        ArrayList<Rule> arrayList = hashMap.get(qName);
        if (arrayList == null) {
            arrayList = this.fastElemMap.get(DEF);
        }
        return arrayList;
    }

    private boolean contextMatch(QName[] qNameArray, Node node) {
        return qNameArray == null;
    }

    private void compileForNodeMatching() {
        this.fastElemMap = this.compileRuleSet(this.elementRules);
        this.fastAttrMap = this.compileRuleSet(this.attributeRules);
    }

    private HashMap<QName, ArrayList<Rule>> compileRuleSet(ArrayList<Rule> arrayList) {
        Object object;
        HashMap<QName, ArrayList<Rule>> hashMap = new HashMap<QName, ArrayList<Rule>>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            Object object2 = this.ruleAt(i, arrayList);
            if (((Rule)object2).indexingType == 1) continue;
            object = ((Rule)object2).name == null ? DEF : ((Rule)object2).name;
            ArrayList<Rule> arrayList2 = hashMap.get(object);
            if (arrayList2 == null) {
                arrayList2 = new ArrayList();
                hashMap.put((QName)object, arrayList2);
            }
            for (n2 = 0; n2 < arrayList2.size() && this.ruleAt(n2, arrayList2).precedes((Rule)object2); ++n2) {
            }
            arrayList2.add(n2, (Rule)object2);
        }
        ArrayList arrayList3 = (ArrayList)hashMap.get(DEF);
        if (arrayList3 != null) {
            for (Object object2 : hashMap.keySet()) {
                if (object2 == DEF) continue;
                object = hashMap.get(object2);
                ((ArrayList)object).addAll(arrayList3);
            }
        }
        return hashMap;
    }

    private Rule ruleAt(int n, ArrayList<Rule> arrayList) {
        return arrayList.get(n);
    }

    private Rule parseRule(Node node) throws DataModelException {
        Node[] nodeArray = node.getAttributes();
        QName qName = null;
        int n = 1;
        QName[] qNameArray = null;
        int n2 = node.getNodeName() == ELEMENT_RULE ? 0 : -1;
        NumberSieve numberSieve = null;
        String[] stringArray = new String[]{};
        int n3 = nodeArray == null ? 0 : nodeArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4;
            String[] stringArray2;
            Node node2 = nodeArray[i];
            QName qName2 = node2.getNodeName();
            if (qName2 == NAME) {
                qName = this.convertName(node2.getStringValue(), node);
                continue;
            }
            if (qName2 == CONTEXT) {
                stringArray2 = new StringTokenizer(node2.getStringValue(), "/ ");
                while (stringArray2.hasMoreTokens()) {
                    String string = stringArray2.nextToken();
                    QName qName3 = this.convertName(string, node);
                    if (qNameArray == null) {
                        qNameArray = new QName[]{qName3};
                        continue;
                    }
                    QName[] qNameArray2 = qNameArray;
                    qNameArray = new QName[qNameArray2.length + 1];
                    System.arraycopy(qNameArray2, 0, qNameArray, 0, qNameArray2.length);
                    qNameArray[qNameArray2.length] = qName3;
                }
                continue;
            }
            if (qName2 == FULLTEXT) {
                n2 = this.booleanProp(node2) ? 1 : -1;
                continue;
            }
            if (qName2 == AS) {
                stringArray2 = node2.getStringValue();
                n = -1;
                n4 = INDEXING_TYPES.length;
                while (--n4 > 0) {
                    if (!INDEXING_TYPES[n4].equalsIgnoreCase((String)stringArray2)) continue;
                    n = INDEXING_CODES[n4];
                    break;
                }
                if (n >= 0) continue;
                this.error("invalid indexing type: " + (String)stringArray2);
                continue;
            }
            if (qName2 == SIEVE) {
                numberSieve = this.sieveProp(node2);
                continue;
            }
            stringArray2 = stringArray;
            n4 = stringArray2.length;
            stringArray = new String[n4 + 2];
            System.arraycopy(stringArray2, 0, stringArray, 0, n4);
            stringArray[n4] = qName2.getLocalPart();
            stringArray[n4 + 1] = node2.getStringValue();
        }
        Rule rule = new Rule(qName, qNameArray, n);
        switch (n) {
            case 2: 
            case 3: {
                if (numberSieve != null) break;
                numberSieve = new FormatNumberSieve();
                break;
            }
            case 4: 
            case 5: {
                if (numberSieve == null) {
                    numberSieve = new ISODateSieve();
                    break;
                }
                if (numberSieve instanceof DateSieve) break;
                this.error("sieve class should implement " + DateSieve.class);
            }
        }
        rule.sieve = numberSieve;
        rule.setFullText((byte)n2);
        if (numberSieve != null) {
            numberSieve.setParameters(stringArray);
        }
        return rule;
    }

    private QName convertName(String string, Node node) throws DataModelException {
        String string2;
        String string3;
        if ("*".equals(string)) {
            return null;
        }
        try {
            String string4 = IQName.extractPrefix(string);
            string3 = IQName.extractLocalName(string);
            string2 = node.getNamespaceUri(string4);
            if (string2 == null) {
                if (string4.length() == 0) {
                    string2 = "";
                } else {
                    this.error("undefined namespace prefix: " + string4);
                }
            }
            if (string2 != "") {
                String string5 = this.namespaces.getNamespaceURI(string4);
                if (string5 == null) {
                    this.namespaces.addMapping(string4, string2);
                } else if (!string5.equals(string2)) {
                    this.error("redefinition of namespace prefix  '" + string4 + "' (not supported)");
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw new DataModelException("Indexing parse error: " + runtimeException.getMessage());
        }
        return IQName.get(string2, string3);
    }

    private boolean booleanProp(Node node) throws DataModelException {
        String string = node.getStringValue();
        if (string.equals("yes") || string.equals("true")) {
            return true;
        }
        if (string.equals("no") || string.equals("false")) {
            return false;
        }
        this.error("invalid boolean property: " + node);
        return false;
    }

    private int integerProp(Node node) throws DataModelException {
        String string = node.getStringValue();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.error("invalid integer property: " + node);
            return 0;
        }
    }

    private NumberSieve sieveProp(Node node) throws DataModelException {
        String string = node.getStringValue();
        if (string == null || string.length() == 0) {
            throw new DataModelException("invalid sieve class");
        }
        NumberSieve numberSieve = this.tryClass(string);
        if (numberSieve != null) {
            return numberSieve;
        }
        int n = string.indexOf(46);
        if (n < 0) {
            string = DEFAULT_SIEVE_PACKAGE + "." + string;
        }
        if ((numberSieve = this.tryClass(string)) == null) {
            this.error("cannot instantiate Sieve class " + string);
        }
        return numberSieve;
    }

    private NumberSieve tryClass(String string) throws DataModelException {
        try {
            return (NumberSieve)Beans.instantiate(this.getClass().getClassLoader(), string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void error(String string) throws DataModelException {
        if (this.ruleRank > 0) {
            string = "[rule " + this.ruleRank + "] " + string;
        }
        throw new DataModelException(string);
    }

    public static interface DateSieve
    extends NumberSieve {
        public double convert(String var1);
    }

    public static interface NumberSieve
    extends Sieve {
        public double convert(String var1);
    }

    public static interface WordSieve
    extends TextTokenizer {
        public WordSieve copy();
    }

    public static interface Sieve {
        public void setParameters(String[] var1) throws DataModelException;

        public String[] getParameters();
    }

    public static class Rule {
        private QName name;
        private QName[] context;
        private NumberSieve sieve;
        private byte indexingType;
        private byte fullText = 0;

        public Rule(QName qName, QName[] qNameArray, int n) {
            this.name = qName;
            this.context = qNameArray;
            this.indexingType = (byte)n;
        }

        public boolean precedes(Rule rule) {
            return this.getContextDepth() >= rule.getContextDepth();
        }

        public void setDefaultSieve() {
            if (this.indexingType == 2 || this.indexingType == 3) {
                this.sieve = new FormatNumberSieve();
            } else if (this.indexingType == 4 || this.indexingType == 5) {
                this.sieve = new ISODateSieve();
            }
        }

        public QName[] getContext() {
            return this.context;
        }

        public int getContextDepth() {
            return this.context == null ? 0 : this.context.length;
        }

        public void setContext(QName[] qNameArray) {
            this.context = qNameArray;
        }

        public final byte getFullText() {
            return this.fullText;
        }

        public void setFullText(byte by) {
            this.fullText = by;
        }

        public QName getName() {
            return this.name;
        }

        public void setName(QName qName) {
            this.name = qName;
        }

        public final NumberSieve getSieve() {
            return this.sieve;
        }

        public void setSieve(NumberSieve numberSieve) {
            this.sieve = numberSieve;
        }

        public final int getIndexingType() {
            return this.indexingType;
        }

        public void setIndexingType(int n) {
            this.indexingType = (byte)n;
        }
    }
}

