/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.util.NamespaceContext;
import com.qizx.xdm.IQName;
import com.qizx.xdm.XMLPushStreamBase;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class PushStreamToDOM
extends XMLPushStreamBase {
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private DOMImplementation implementation;
    private Document document;
    private Element rootElement;
    private Element current;
    private Text latestText;

    public PushStreamToDOM() throws DataModelException {
        try {
            this.implementation = factory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DataModelException("DOM factory error: " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
    }

    public PushStreamToDOM(DOMImplementation dOMImplementation) {
        this.implementation = dOMImplementation;
    }

    public org.w3c.dom.Node exportNode(Node node) throws DataModelException {
        QName qName = node.getNodeName();
        switch (node.getNodeNature()) {
            case 1: {
                this.putNodeCopy(node, 0);
                return this.getResultDocument();
            }
            case 2: {
                this.putNodeCopy(node, 0);
                return this.getResultDocument().getDocumentElement();
            }
            case 3: {
                Attr attr = this.initDoc().createAttributeNS(qName.getNamespaceURI(), qName.getLocalPart());
                attr.setNodeValue(node.getStringValue());
                return attr;
            }
            case 6: {
                return this.initDoc().createComment(node.getStringValue());
            }
            case 5: {
                return this.initDoc().createProcessingInstruction(qName.getLocalPart(), node.getStringValue());
            }
        }
        return this.initDoc().createTextNode(node.getStringValue());
    }

    public Document getResultDocument() {
        return this.document;
    }

    public boolean putDocumentStart() throws DataModelException {
        if (this.rootElement != null) {
            return false;
        }
        boolean bl = super.putDocumentStart();
        this.initDoc();
        return bl;
    }

    private Document initDoc() {
        this.current = null;
        this.rootElement = null;
        this.document = this.implementation.createDocument("", "Dummy", null);
        this.document.removeChild(this.document.getFirstChild());
        return this.document;
    }

    public void putElementStart(QName qName) throws DataModelException {
        super.putElementStart(qName);
        this.spaceNeeded = false;
    }

    public void putElementEnd(QName qName) throws DataModelException {
        if (this.elementStarted) {
            this.flushElementStart(false);
        } else {
            this.flushText();
        }
        if (this.current == null) {
            throw new DataModelException("unbalanced end of element: " + qName);
        }
        org.w3c.dom.Node node = this.current.getParentNode();
        this.current = node == null || node.getNodeType() == 9 ? null : (Element)node;
        super.putElementEnd(qName);
    }

    protected void flushElementStart(boolean bl) throws DataModelException {
        this.flushText();
        this.completeNameMappings();
        String string = this.elementName.getNamespaceURI();
        Element element = this.document.createElementNS(string, this.qualifiedName(this.elementName));
        this.openElement(element);
        for (int i = 0; i < this.attrCnt; ++i) {
            IQName iQName = this.attrNames[i];
            String string2 = iQName.getNamespaceURI();
            Attr attr = this.document.createAttributeNS(string2, this.qualifiedName(iQName));
            attr.setValue(this.attrValues[i]);
            this.current.setAttributeNode(attr);
        }
        this.elementStarted = false;
    }

    private void flushText() {
        this.latestText = null;
    }

    public void putText(String string) throws DataModelException {
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.elementStarted) {
            this.flushElementStart(false);
        }
        if (this.latestText != null) {
            this.latestText.appendData(string);
        } else {
            this.latestText = this.document.createTextNode(string);
            this.addAtom(this.latestText);
        }
    }

    public void putComment(String string) throws DataModelException {
        this.flushText();
        super.putComment(string);
        Comment comment = this.document.createComment(string);
        this.addAtom(comment);
    }

    public void putProcessingInstruction(String string, String string2) throws DataModelException {
        this.flushText();
        super.putProcessingInstruction(string, string2);
        ProcessingInstruction processingInstruction = this.document.createProcessingInstruction(string, string2);
        this.addAtom(processingInstruction);
    }

    public void reset() {
        super.reset();
        this.flushText();
    }

    private String qualifiedName(QName qName) {
        String string = qName.getNamespaceURI();
        if (string == NamespaceContext.XML) {
            return "xml:" + qName.getLocalPart();
        }
        String string2 = this.nsContext.getPrefix(string);
        if (string2 == null && string.length() > 0) {
            throw new RuntimeException("cannot map NS " + string);
        }
        if (string2 != null && string2.length() > 0) {
            return string2 + ':' + qName.getLocalPart();
        }
        return qName.getLocalPart();
    }

    private void addAtom(org.w3c.dom.Node node) throws DataModelException {
        if (this.current == null) {
            return;
        }
        this.current.appendChild(node);
    }

    private void openElement(Element element) throws DataModelException {
        if (this.current == null) {
            if (this.rootElement != null) {
                throw new DataModelException("adding node after root");
            }
            this.rootElement = element;
            if (this.rootElement.getNodeType() == 1) {
                this.current = this.rootElement;
            }
            this.document.appendChild(element);
        } else {
            this.current.appendChild(element);
        }
        this.current = element;
        this.spaceNeeded = false;
    }
}

