/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util;

import com.qizx.api.DataModelException;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.XMLPushStream;
import com.qizx.util.CharTable;
import com.qizx.util.NamespaceContext;
import com.qizx.util.basic.Util;
import com.qizx.util.basic.XMLUtil;
import com.qizx.xdm.BasicNode;
import com.qizx.xdm.XMLPushStreamBase;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;

public class XMLSerializer
extends XMLPushStreamBase
implements XMLPushStream {
    public static final String METHOD = "method";
    public static final String ENCODING = "encoding";
    public static final String VERSION = "version";
    public static final String OMIT_XML_DECLARATION = "omit-xml-declaration";
    public static final String STANDALONE = "standalone";
    public static final String DOCTYPE_SYSTEM = "doctype-system";
    public static final String DOCTYPE_PUBLIC = "doctype-public";
    public static final String INCLUDE_CONTENT_TYPE = "include-content-type";
    public static final String MEDIA_TYPE = "media-type";
    public static final String ESCAPE_URI_ATTRIBUTES = "escape-uri-attributes";
    public static final String INDENT = "indent";
    public static final String INDENT_VALUE = "indent-value";
    public static final String STRIP_PI = "strip-pi";
    public static final String STRIP_COMMENT = "strip-comment";
    public static final String AUTO_DTD = "auto-dtd";
    private static final String UTF8 = "UTF-8";
    static final String XHTML = NamespaceContext.unique("http://www.w3.org/1999/xhtml");
    private static final HashMap Encodings = new HashMap();
    private BufferedWriter out = new BufferedWriter(new OutputStreamWriter(System.out));
    private Method method = new XMLMethod();
    private boolean omitXmlDecl = false;
    private boolean escapeUriAttr = true;
    private boolean includeContentType = true;
    private boolean standalone = false;
    private boolean indents = false;
    private boolean stripPI = false;
    private boolean stripComment = false;
    private boolean autoDTD = true;
    private boolean dummy = false;
    private int maxDepth = -1;
    private int indentValue = -1;
    private String encoding = "UTF-8";
    private String version = "1.0";
    private String mediaType;
    private boolean enableIndent;
    private boolean firstElement;
    private String indentPadding;
    private int depth;
    private boolean atBol = true;
    private CharsetEncoder encoder;
    static CharTable HTML4Entities;

    public XMLSerializer() {
    }

    public XMLSerializer(OutputStream outputStream, String string) throws DataModelException {
        this.setOutput(outputStream, string);
    }

    public XMLSerializer(Writer writer) {
        try {
            this.setOutput(writer);
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
    }

    public XMLSerializer(String string) throws DataModelException {
        this.setOption(METHOD, string);
    }

    public void setOutput(OutputStream outputStream, String string) throws DataModelException {
        OutputStreamWriter outputStreamWriter = string == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, Charset.forName(string));
        this.out = new BufferedWriter(outputStreamWriter);
        this.setEncoding(string);
    }

    public void setOutput(Writer writer) throws DataModelException {
        if (writer instanceof OutputStreamWriter) {
            this.setEncoding(((OutputStreamWriter)writer).getEncoding());
        }
        if (writer != null) {
            this.out = new BufferedWriter(writer);
        }
    }

    public void setOutput(OutputStream outputStream) throws DataModelException {
        this.setOutput(outputStream, UTF8);
    }

    public BufferedWriter getOutput() {
        return this.out;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) throws DataModelException {
        if (string == null) {
            this.encoding = UTF8;
            this.encoder = null;
            return;
        }
        String string2 = (String)Encodings.get(string);
        if (string2 == null) {
            string2 = string;
        }
        this.encoding = string2;
        try {
            Charset charset = Charset.forName(string2);
            this.encoder = charset.newEncoder();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataModelException(illegalArgumentException.getMessage());
        }
    }

    public boolean hasAutoDTD() {
        return this.autoDTD;
    }

    public void setOmitXMLDeclaration(boolean bl) {
        this.omitXmlDecl = bl;
    }

    public void output(Node node) throws DataModelException {
        this.reset();
        this.putNodeCopy(node, 0);
        this.flush();
    }

    public void putNodeCopy(Node node, int n) throws DataModelException {
        String[] stringArray;
        if (this.autoDTD && !this.omitXmlDecl && node instanceof BasicNode && (stringArray = ((BasicNode)node).getDTDInfo()) != null) {
            this.dtdName = stringArray[0];
            this.dtdSystemId = stringArray[1];
            if (this.dtdSystemId != null && this.dtdSystemId.length() == 0) {
                this.dtdSystemId = null;
            }
            this.dtdPublicId = stringArray[2];
            if (this.dtdPublicId != null && this.dtdPublicId.length() == 0) {
                this.dtdPublicId = null;
            }
        }
        super.putNodeCopy(node, n);
    }

    public String serializeToString(Node node) throws DataModelException {
        this.reset();
        this.startDocumentDone = true;
        StringWriter stringWriter = new StringWriter(20);
        this.setOutput(stringWriter);
        this.putNodeCopy(node, 0);
        this.flush();
        return stringWriter.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOption(String string, String string2) throws DataModelException {
        if (string.equalsIgnoreCase(METHOD)) {
            if (string2.equalsIgnoreCase("XML")) {
                this.method = new XMLMethod();
                return;
            } else if (string2.equalsIgnoreCase("XHTML")) {
                this.method = new HTMLMethod(true);
                return;
            } else if (string2.equalsIgnoreCase("HTML")) {
                this.method = new HTMLMethod(false);
                this.omitXmlDecl = true;
                this.setEncoding("ISO-8859-1");
                return;
            } else {
                if (!string2.equalsIgnoreCase("TEXT")) throw new DataModelException("invalid method: " + string2);
                this.omitXmlDecl = true;
                this.method = new TextMethod();
            }
            return;
        } else if (string.equalsIgnoreCase(ENCODING)) {
            this.setEncoding(string2);
            return;
        } else if (string.equalsIgnoreCase(VERSION)) {
            this.version = string2;
            return;
        } else if (string.equalsIgnoreCase(OMIT_XML_DECLARATION)) {
            this.omitXmlDecl = this.boolOption(string, string2);
            return;
        } else if (string.equalsIgnoreCase(STANDALONE)) {
            this.standalone = this.boolOption(string, string2);
            return;
        } else if (string.equalsIgnoreCase(DOCTYPE_SYSTEM)) {
            this.dtdSystemId = string2;
            return;
        } else if (string.equalsIgnoreCase(DOCTYPE_PUBLIC)) {
            this.dtdPublicId = string2;
            return;
        } else if (string.equalsIgnoreCase(MEDIA_TYPE)) {
            this.mediaType = string2;
            return;
        } else if (string.equalsIgnoreCase(ESCAPE_URI_ATTRIBUTES)) {
            this.escapeUriAttr = this.boolOption(string, string2);
            return;
        } else if (string.equalsIgnoreCase(INCLUDE_CONTENT_TYPE)) {
            this.includeContentType = this.boolOption(string, string2);
            return;
        } else if (string.equalsIgnoreCase(INDENT)) {
            this.indents = this.boolOption(string, string2);
            if (!this.indents || this.indentValue >= 0) return;
            this.setIndent(2);
            return;
        } else if (string.equalsIgnoreCase(INDENT_VALUE)) {
            this.setIndent(Integer.parseInt(string2));
            return;
        } else if (string.equalsIgnoreCase(STRIP_PI)) {
            this.stripPI = this.boolOption(string, string2);
            return;
        } else if (string.equalsIgnoreCase(STRIP_COMMENT)) {
            this.stripComment = this.boolOption(string, string2);
            return;
        } else if (string.equalsIgnoreCase(AUTO_DTD)) {
            this.autoDTD = this.boolOption(string, string2);
            return;
        } else {
            if (!string.equalsIgnoreCase("dummy-display")) throw new DataModelException("invalid option: " + string);
            this.dummy = this.boolOption(string, string2);
        }
    }

    private boolean boolOption(String string, String string2) throws DataModelException {
        if (string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true") || string2.equals("1")) {
            return true;
        }
        if (string2.equalsIgnoreCase("no") || string2.equalsIgnoreCase("false") || string2.equals("0")) {
            return false;
        }
        throw new DataModelException("invalid value of option '" + string + "': " + string2);
    }

    public void setIndent(int n) {
        this.indents = n >= 0;
        this.indentValue = n;
        int n2 = Math.min(this.indentValue, 16);
        this.indentPadding = this.indents ? "                ".substring(0, n2) : null;
    }

    public void reset() {
        super.reset();
        this.depth = 0;
        this.enableIndent = false;
        this.atBol = true;
        this.firstElement = true;
        if (this.standalone || !UTF8.equals(this.encoding)) {
            this.omitXmlDecl = false;
        }
    }

    public void flush() throws DataModelException {
        if (this.indents && !this.atBol) {
            this.println();
        }
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new DataModelException("IO error", iOException);
        }
    }

    public boolean putDocumentStart() throws DataModelException {
        if (this.startDocumentDone) {
            return false;
        }
        boolean bl = super.putDocumentStart();
        this.method.outputHeader();
        return bl;
    }

    public void putDocumentEnd() throws DataModelException {
        super.putDocumentEnd();
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void flushElementStart(boolean bl) throws DataModelException {
        int n;
        if (!this.elementStarted || this.method.onlyText()) {
            return;
        }
        if (this.firstElement) {
            if (!(this.omitXmlDecl || this.dtdPublicId == null && this.dtdSystemId == null)) {
                this.print("<!DOCTYPE ");
                if (this.dtdName == null) {
                    this.dtdName = this.elementName.getLocalPart();
                }
                this.print(this.dtdName);
                if (this.dtdPublicId != null) {
                    this.print(" PUBLIC \"");
                    this.print(this.dtdPublicId);
                    this.print("\"");
                    if (this.dtdSystemId != null) {
                        this.print(" \"");
                        this.print(this.dtdSystemId);
                        this.print("\"");
                    }
                } else if (this.dtdSystemId != null) {
                    this.print(" SYSTEM \"");
                    this.print(this.dtdSystemId);
                    this.print("\"");
                }
                this.print(">");
                this.println();
            }
            this.firstElement = false;
        }
        this.completeNameMappings();
        this.doIndent();
        this.print('<');
        this.printQName(this.elementName, false);
        for (n = 0; n < this.attrCnt; ++n) {
            this.print(' ');
            this.printQName(this.attrNames[n], true);
            this.print("=\"");
            this.method.outputAttr(this.attrValues[n], this.attrNames[n]);
            this.print('\"');
        }
        int n2 = this.nsContext.size();
        for (n = this.nsContext.mark(); n < n2; ++n) {
            String string;
            this.print(" xmlns");
            String string2 = this.nsContext.getNamespaceURI(n);
            if (string2 == null) {
                string2 = "";
            }
            if ((string = this.nsContext.getPrefix(n)).length() > 0) {
                this.print(':');
                this.print(string);
            }
            this.print("=\"");
            this.method.outputAttr(string2, null);
            this.print("\"");
        }
        this.print(bl ? this.method.endOfEmptyTag() : ">");
        this.elementStarted = false;
        this.enableIndent = true;
        this.spaceNeeded = false;
        this.method.afterStartTag();
        ++this.depth;
    }

    public void putElementEnd(QName qName) throws DataModelException {
        if (this.method.onlyText()) {
            return;
        }
        boolean bl = this.elementStarted;
        if (this.elementStarted) {
            bl = this.method.isMinimized(qName);
            this.flushElementStart(bl);
        }
        --this.depth;
        if (this.depth < 0) {
            throw new DataModelException("unbalanced element " + qName);
        }
        if (!bl) {
            this.doIndent();
            this.print("</");
            this.printQName(qName, false);
            this.print('>');
        }
        super.putElementEnd(qName);
        this.enableIndent = true;
        this.spaceNeeded = false;
    }

    public void putText(String string) throws DataModelException {
        if (this.trace) {
            System.err.println("-- text |" + string + '|');
        }
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.elementStarted) {
            this.flushElementStart(false);
        }
        int n = string.length();
        if (this.indentPadding != null) {
            while (--n >= 0 && Character.isWhitespace(string.charAt(n))) {
            }
        }
        this.enableIndent = n < 0;
        this.method.outputText(string);
        this.spaceNeeded = false;
    }

    public void putAtomText(String string) throws DataModelException {
        if (this.spaceNeeded && !this.atBol) {
            this.putText(" ");
        }
        this.putText(string);
        this.spaceNeeded = true;
    }

    public void putProcessingInstruction(String string, String string2) throws DataModelException {
        super.putProcessingInstruction(string, string2);
        if (this.method.onlyText() || this.stripPI) {
            return;
        }
        this.doIndent();
        this.print("<?");
        this.print(string);
        this.print(' ');
        this.print(string2);
        this.print(this.method.endOfPI());
        this.spaceNeeded = false;
    }

    public void putComment(String string) throws DataModelException {
        super.putComment(string);
        if (this.method.onlyText() || this.stripComment) {
            return;
        }
        this.doIndent();
        this.print("<!--");
        this.print(string);
        this.print("-->");
        this.spaceNeeded = false;
    }

    void printQName(QName qName, boolean bl) {
        String string = qName.getNamespaceURI();
        if (string == NamespaceContext.XML) {
            this.print("xml:");
            this.print(qName.getLocalPart());
        } else {
            String string2 = this.nsContext.getPrefix(string);
            if (string2 != null && string2.length() > 0) {
                this.print(string2);
                this.print(':');
            }
            this.print(qName.getLocalPart());
        }
    }

    private void doIndent() {
        if (this.enableIndent && this.indentPadding != null) {
            this.println();
            for (int i = 0; i < this.depth; ++i) {
                this.print(this.indentPadding);
            }
            this.enableIndent = false;
            this.atBol = false;
        }
    }

    private void print(String string) {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            return;
        }
        try {
            if (!this.dummy) {
                this.out.write(string);
            }
            this.volume += (long)string.length();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void print(CharSequence charSequence) {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            return;
        }
        try {
            int n = charSequence.length();
            if (!this.dummy) {
                for (int i = 0; i < n; ++i) {
                    this.out.write(charSequence.charAt(i));
                }
            }
            this.volume += (long)n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void print(char c) {
        if (this.maxVolume > 0L && this.volume > this.maxVolume || this.dummy) {
            return;
        }
        try {
            if (!XMLUtil.isSurrogateChar(c)) {
                if (this.encoder != null && !this.encoder.canEncode(c)) {
                    this.print("&#");
                    this.print(Integer.toString(c));
                    this.print(";");
                } else {
                    this.out.write(c);
                }
            }
            ++this.volume;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void println() {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            return;
        }
        try {
            if (!this.dummy) {
                this.out.newLine();
            }
            ++this.volume;
            this.atBol = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        Encodings.put("UTF8", UTF8);
        Encodings.put("UTF16", "UTF-16");
        Encodings.put("ISO8859-1", "ISO-8859-1");
        Encodings.put("ISO8859_1", "ISO-8859-1");
        Encodings.put("ISO8859-2", "ISO-8859-2");
        Encodings.put("ISO8859_2", "ISO-8859-2");
        Encodings.put("ISO8859-3", "ISO-8859-3");
        Encodings.put("ISO8859_3", "ISO-8859-3");
        Encodings.put("ISO8859-4", "ISO-8859-4");
        Encodings.put("ISO8859_4", "ISO-8859-4");
        Encodings.put("ISO8859-5", "ISO-8859-5");
        Encodings.put("ISO8859_5", "ISO-8859-5");
        Encodings.put("ISO8859-6", "ISO-8859-6");
        Encodings.put("ISO8859_6", "ISO-8859-6");
        Encodings.put("ISO8859-7", "ISO-8859-7");
        Encodings.put("ISO8859_7", "ISO-8859-7");
        Encodings.put("ISO8859-9", "ISO-8859-9");
        Encodings.put("ISO8859_9", "ISO-8859-9");
        Encodings.put("ISO8859-13", "ISO-8859-13");
        Encodings.put("ISO8859_13", "ISO-8859-13");
        Encodings.put("ISO8859-15", "ISO-8859-15");
        Encodings.put("ISO8859_15", "ISO-8859-15");
        Encodings.put("KOI8R", "KOI8-R");
        HTML4Entities = new CharTable();
        HTML4Entities.put(38, "amp");
        HTML4Entities.put(160, "nbsp");
        HTML4Entities.put(913, "Alpha");
        HTML4Entities.put(914, "Beta");
        HTML4Entities.put(915, "Gamma");
        HTML4Entities.put(916, "Delta");
        HTML4Entities.put(917, "Epsilon");
        HTML4Entities.put(918, "Zeta");
        HTML4Entities.put(919, "Eta");
        HTML4Entities.put(920, "Theta");
        HTML4Entities.put(921, "Iota");
        HTML4Entities.put(922, "Kappa");
        HTML4Entities.put(923, "Lambda");
        HTML4Entities.put(924, "Mu");
        HTML4Entities.put(925, "Nu");
        HTML4Entities.put(926, "Xi");
        HTML4Entities.put(927, "Omicron");
        HTML4Entities.put(928, "Pi");
        HTML4Entities.put(929, "Rho");
        HTML4Entities.put(931, "Sigma");
        HTML4Entities.put(932, "Tau");
        HTML4Entities.put(933, "Upsilon");
        HTML4Entities.put(934, "Phi");
        HTML4Entities.put(935, "Chi");
        HTML4Entities.put(936, "Psi");
        HTML4Entities.put(937, "Omega");
        HTML4Entities.put(945, "alpha");
        HTML4Entities.put(946, "beta");
        HTML4Entities.put(947, "gamma");
        HTML4Entities.put(948, "delta");
        HTML4Entities.put(949, "epsilon");
        HTML4Entities.put(950, "zeta");
        HTML4Entities.put(951, "eta");
        HTML4Entities.put(952, "theta");
        HTML4Entities.put(953, "iota");
        HTML4Entities.put(954, "kappa");
        HTML4Entities.put(955, "lambda");
        HTML4Entities.put(956, "mu");
        HTML4Entities.put(957, "nu");
        HTML4Entities.put(958, "xi");
        HTML4Entities.put(959, "omicron");
        HTML4Entities.put(960, "pi");
        HTML4Entities.put(961, "rho");
        HTML4Entities.put(962, "sigmaf");
        HTML4Entities.put(963, "sigma");
        HTML4Entities.put(964, "tau");
        HTML4Entities.put(965, "upsilon");
        HTML4Entities.put(966, "phi");
        HTML4Entities.put(967, "chi");
        HTML4Entities.put(968, "psi");
        HTML4Entities.put(969, "omega");
        HTML4Entities.put(977, "thetasym");
        HTML4Entities.put(978, "upsih");
        HTML4Entities.put(982, "piv");
        HTML4Entities.put(8226, "bull");
        HTML4Entities.put(8230, "hellip");
        HTML4Entities.put(8242, "prime");
        HTML4Entities.put(8243, "Prime");
        HTML4Entities.put(8254, "oline");
        HTML4Entities.put(8260, "frasl");
        HTML4Entities.put(8472, "weierp");
        HTML4Entities.put(8465, "image");
        HTML4Entities.put(8476, "real");
        HTML4Entities.put(8482, "trade");
        HTML4Entities.put(8501, "alefsym");
        HTML4Entities.put(8592, "larr");
        HTML4Entities.put(8593, "uarr");
        HTML4Entities.put(8594, "rarr");
        HTML4Entities.put(8595, "darr");
        HTML4Entities.put(8596, "harr");
        HTML4Entities.put(8629, "crarr");
        HTML4Entities.put(8656, "lArr");
        HTML4Entities.put(8657, "uArr");
        HTML4Entities.put(8658, "rArr");
        HTML4Entities.put(8659, "dArr");
        HTML4Entities.put(8660, "hArr");
        HTML4Entities.put(8704, "forall");
        HTML4Entities.put(8706, "part");
        HTML4Entities.put(8707, "exist");
        HTML4Entities.put(8709, "empty");
        HTML4Entities.put(8711, "nabla");
        HTML4Entities.put(8712, "isin");
        HTML4Entities.put(8713, "notin");
        HTML4Entities.put(8715, "ni");
        HTML4Entities.put(8719, "prod");
        HTML4Entities.put(8721, "sum");
        HTML4Entities.put(8722, "minus");
        HTML4Entities.put(8727, "lowast");
        HTML4Entities.put(8730, "radic");
        HTML4Entities.put(8733, "prop");
        HTML4Entities.put(8734, "infin");
        HTML4Entities.put(8736, "ang");
        HTML4Entities.put(8743, "and");
        HTML4Entities.put(8744, "or");
        HTML4Entities.put(8745, "cap");
        HTML4Entities.put(8746, "cup");
        HTML4Entities.put(8747, "int");
        HTML4Entities.put(8756, "there4");
        HTML4Entities.put(8764, "sim");
        HTML4Entities.put(8773, "cong");
        HTML4Entities.put(8776, "asymp");
        HTML4Entities.put(8800, "ne");
        HTML4Entities.put(8801, "equiv");
        HTML4Entities.put(8804, "le");
        HTML4Entities.put(8805, "ge");
        HTML4Entities.put(8834, "sub");
        HTML4Entities.put(8835, "sup");
        HTML4Entities.put(8836, "nsub");
        HTML4Entities.put(8838, "sube");
        HTML4Entities.put(8839, "supe");
        HTML4Entities.put(8853, "oplus");
        HTML4Entities.put(8855, "otimes");
        HTML4Entities.put(8869, "perp");
        HTML4Entities.put(8901, "sdot");
        HTML4Entities.put(8968, "lceil");
        HTML4Entities.put(8969, "rceil");
        HTML4Entities.put(8970, "lfloor");
        HTML4Entities.put(8971, "rfloor");
        HTML4Entities.put(9001, "lang");
        HTML4Entities.put(9002, "rang");
        HTML4Entities.put(9674, "loz");
        HTML4Entities.put(9824, "spades");
        HTML4Entities.put(9827, "clubs");
        HTML4Entities.put(9829, "hearts");
        HTML4Entities.put(9830, "diams");
        HTML4Entities.put(34, "quot");
        HTML4Entities.put(38, "amp");
        HTML4Entities.put(60, "lt");
        HTML4Entities.put(62, "gt");
        HTML4Entities.put(338, "OElig");
        HTML4Entities.put(339, "oelig");
        HTML4Entities.put(352, "Scaron");
        HTML4Entities.put(353, "scaron");
        HTML4Entities.put(376, "Yuml");
        HTML4Entities.put(710, "circ");
        HTML4Entities.put(732, "tilde");
        HTML4Entities.put(8194, "ensp");
        HTML4Entities.put(8195, "emsp");
        HTML4Entities.put(8201, "thinsp");
        HTML4Entities.put(8204, "zwnj");
        HTML4Entities.put(8205, "zwj");
        HTML4Entities.put(8206, "lrm");
        HTML4Entities.put(8207, "rlm");
        HTML4Entities.put(8211, "ndash");
        HTML4Entities.put(8212, "mdash");
        HTML4Entities.put(8216, "lsquo");
        HTML4Entities.put(8217, "rsquo");
        HTML4Entities.put(8218, "sbquo");
        HTML4Entities.put(8220, "ldquo");
        HTML4Entities.put(8221, "rdquo");
        HTML4Entities.put(8222, "bdquo");
        HTML4Entities.put(8224, "dagger");
        HTML4Entities.put(8225, "Dagger");
        HTML4Entities.put(8240, "permil");
        HTML4Entities.put(8249, "lsaquo");
        HTML4Entities.put(8250, "rsaquo");
        HTML4Entities.put(8364, "euro");
    }

    protected class TextMethod
    extends XMLMethod {
        protected TextMethod() {
        }

        public void outputHeader() {
        }

        public boolean onlyText() {
            return true;
        }

        public void outputText(CharSequence charSequence) {
            XMLSerializer.this.print(charSequence);
        }
    }

    protected class HTMLMethod
    extends XMLMethod {
        boolean xhtml;
        boolean noEscape;

        HTMLMethod(boolean bl) {
            this.noEscape = false;
            this.xhtml = bl;
            if (!bl) {
                XMLSerializer.this.dtdPublicId = "-//W3C//DTD HTML 4.01 Transitional//EN";
            }
        }

        boolean isHTML(String string) {
            return string == XHTML || !this.xhtml && string == NamespaceContext.EMPTY;
        }

        public String endOfEmptyTag() {
            return this.xhtml ? " />" : ">";
        }

        public boolean isMinimized(QName qName) {
            if (!this.isHTML(qName.getNamespaceURI())) {
                return false;
            }
            String string = qName.getLocalPart();
            switch (Character.toLowerCase(string.charAt(0))) {
                case 'a': {
                    return string.equalsIgnoreCase("area");
                }
                case 'b': {
                    return string.equalsIgnoreCase("br") || string.equalsIgnoreCase("base") || string.equalsIgnoreCase("basefont");
                }
                case 'c': {
                    return string.equalsIgnoreCase("col");
                }
                case 'f': {
                    return string.equalsIgnoreCase("frame");
                }
                case 'h': {
                    return string.equalsIgnoreCase("hr");
                }
                case 'i': {
                    return string.equalsIgnoreCase("img") || string.equalsIgnoreCase("input") || string.equalsIgnoreCase("isindex");
                }
                case 'l': {
                    return string.equalsIgnoreCase("link");
                }
                case 'm': {
                    return string.equalsIgnoreCase("meta");
                }
                case 'p': {
                    return string.equalsIgnoreCase("param");
                }
            }
            return false;
        }

        public void afterStartTag() {
            if (this.isHTML(XMLSerializer.this.elementName.getNamespaceURI())) {
                String string = XMLSerializer.this.elementName.getLocalPart();
                if (XMLSerializer.this.includeContentType && string.equalsIgnoreCase("head")) {
                    XMLSerializer.this.print("<meta http-equiv='Content-Type' content='text/html; charset=" + XMLSerializer.this.encoding + "'" + this.endOfEmptyTag());
                }
                if (!this.xhtml && (string.equalsIgnoreCase("script") || string.equalsIgnoreCase("style"))) {
                    this.noEscape = true;
                }
            }
        }

        public void outputHeader() {
            if (this.xhtml) {
                super.outputHeader();
            }
        }

        public void outputText(CharSequence charSequence) {
            if (this.noEscape) {
                XMLSerializer.this.print(charSequence);
                this.noEscape = false;
                return;
            }
            int n = charSequence.length();
            block7: for (int i = 0; i < n; ++i) {
                char c = charSequence.charAt(i);
                switch (c) {
                    case '\n': {
                        XMLSerializer.this.println();
                        continue block7;
                    }
                    case '\r': {
                        XMLSerializer.this.print("&#13;");
                        continue block7;
                    }
                    case '&': {
                        XMLSerializer.this.print("&amp;");
                        continue block7;
                    }
                    case '<': {
                        XMLSerializer.this.print("&lt;");
                        continue block7;
                    }
                    case '>': {
                        XMLSerializer.this.print("&gt;");
                        continue block7;
                    }
                    default: {
                        this.outputHTMLChar(c);
                    }
                }
            }
        }

        public void outputAttr(String string, QName qName) {
            if (XMLSerializer.this.escapeUriAttr && qName != null && this.isUriAttribute(qName)) {
                string = Util.escapeHtmlURI(string);
            }
            boolean bl = false;
            int n = string.length();
            block6: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (!bl) {
                            XMLSerializer.this.print(' ');
                        }
                        bl = true;
                        continue block6;
                    }
                    case '&': {
                        XMLSerializer.this.print("&amp;");
                        continue block6;
                    }
                    case '<': {
                        if (this.xhtml) {
                            XMLSerializer.this.print("&lt;");
                            continue block6;
                        }
                        XMLSerializer.this.print(c);
                        continue block6;
                    }
                    case '\"': {
                        XMLSerializer.this.print("&#34;");
                        continue block6;
                    }
                    default: {
                        this.outputHTMLChar(c);
                        bl = false;
                    }
                }
            }
        }

        private boolean isUriAttribute(QName qName) {
            String string = qName.getLocalPart();
            switch (Character.toLowerCase(string.charAt(0))) {
                case 'a': {
                    return string.equalsIgnoreCase("action") || string.equalsIgnoreCase("archive");
                }
                case 'b': {
                    return string.equalsIgnoreCase("background");
                }
                case 'c': {
                    return string.equalsIgnoreCase("cite") || string.equalsIgnoreCase("classid") || string.equalsIgnoreCase("codebase");
                }
                case 'd': {
                    return string.equalsIgnoreCase("data") || string.equalsIgnoreCase("datasrc");
                }
                case 'f': {
                    return string.equalsIgnoreCase("for");
                }
                case 'h': {
                    return string.equalsIgnoreCase("href");
                }
                case 'l': {
                    return string.equalsIgnoreCase("longdesc");
                }
                case 'n': {
                    return string.equalsIgnoreCase("name");
                }
                case 'p': {
                    return string.equalsIgnoreCase("profile");
                }
                case 's': {
                    return string.equalsIgnoreCase("src");
                }
                case 'u': {
                    return string.equalsIgnoreCase("usemap");
                }
            }
            return false;
        }

        private void outputHTMLChar(char c) {
            String string;
            if (!this.xhtml && XMLSerializer.this.encoder != null && !XMLSerializer.this.encoder.canEncode(c) && (string = (String)HTML4Entities.get(c)) != null) {
                XMLSerializer.this.print("&");
                XMLSerializer.this.print(string);
                XMLSerializer.this.print(";");
                return;
            }
            XMLSerializer.this.print(c);
        }

        public String endOfPI() {
            return this.xhtml ? "?>" : ">";
        }
    }

    protected class XMLMethod
    implements Method {
        protected XMLMethod() {
        }

        public boolean onlyText() {
            return false;
        }

        public String endOfEmptyTag() {
            return "/>";
        }

        public void afterStartTag() {
        }

        public boolean isMinimized(QName qName) {
            return true;
        }

        public void outputText(CharSequence charSequence) {
            int n = charSequence.length();
            block7: for (int i = 0; i < n; ++i) {
                char c = charSequence.charAt(i);
                switch (c) {
                    case '\n': {
                        XMLSerializer.this.println();
                        continue block7;
                    }
                    case '\r': {
                        XMLSerializer.this.print("&#13;");
                        continue block7;
                    }
                    case '&': {
                        XMLSerializer.this.print("&amp;");
                        continue block7;
                    }
                    case '<': {
                        XMLSerializer.this.print("&lt;");
                        continue block7;
                    }
                    case '>': {
                        XMLSerializer.this.print("&gt;");
                        continue block7;
                    }
                    default: {
                        XMLSerializer.this.print(c);
                    }
                }
            }
        }

        public void outputAttr(String string, QName qName) {
            int n = string.length();
            block8: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\t': {
                        XMLSerializer.this.print("&#9;");
                        continue block8;
                    }
                    case '\n': {
                        XMLSerializer.this.print("&#10;");
                        continue block8;
                    }
                    case '\r': {
                        XMLSerializer.this.print("&#13;");
                        continue block8;
                    }
                    case '&': {
                        XMLSerializer.this.print("&amp;");
                        continue block8;
                    }
                    case '<': {
                        XMLSerializer.this.print("&lt;");
                        continue block8;
                    }
                    case '\"': {
                        XMLSerializer.this.print("&quot;");
                        continue block8;
                    }
                    default: {
                        XMLSerializer.this.print(c);
                    }
                }
            }
        }

        public String endOfPI() {
            return "?>";
        }

        public void outputHeader() {
            if (!XMLSerializer.this.omitXmlDecl) {
                XMLSerializer.this.print("<?xml version='");
                XMLSerializer.this.print(XMLSerializer.this.version);
                XMLSerializer.this.print('\'');
                XMLSerializer.this.print(" encoding='" + XMLSerializer.this.encoding + '\'');
                XMLSerializer.this.print("?>");
                XMLSerializer.this.println();
            }
        }
    }

    protected static interface Method {
        public boolean onlyText();

        public boolean isMinimized(QName var1);

        public void afterStartTag();

        public String endOfEmptyTag();

        public String endOfPI();

        public void outputAttr(String var1, QName var2);

        public void outputText(CharSequence var1);

        public void outputHeader();
    }
}

