/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util.fulltext;

import com.qizx.api.DataModelException;
import com.qizx.api.EvaluationException;
import com.qizx.api.Expression;
import com.qizx.api.Node;
import com.qizx.api.QName;
import com.qizx.api.fulltext.FullTextFactory;
import com.qizx.api.fulltext.FullTextPullStream;
import com.qizx.api.util.fulltext.FullTextHighlighter;
import com.qizx.queries.FullText;
import com.qizx.util.basic.Check;
import com.qizx.util.basic.IntSet;
import com.qizx.xdm.CorePushBuilder;
import com.qizx.xdm.XMLPullStreamBase;
import java.util.ArrayList;

public class FullTextSnippetExtractor
extends XMLPullStreamBase
implements FullTextPullStream {
    public static final int GAP = 9;
    static final String ELLIPSIS = " ... ";
    private int maxSnippetSize = 20;
    private int maxWorkSize = 500;
    private FullTextHighlighter stream;
    private int termCount;
    private ArrayList chunks;
    private int bestScore;
    private int bestChunk;
    private ArrayList snippetChunks;
    private int currentChunk;

    public FullTextSnippetExtractor(Expression expression) throws EvaluationException {
        this.stream = new FullTextHighlighter(expression);
    }

    public FullTextSnippetExtractor(String string, FullTextFactory fullTextFactory, String string2) throws DataModelException {
        this.stream = new FullTextHighlighter(string, fullTextFactory, string2);
    }

    public FullTextSnippetExtractor(FullText.Selection selection, FullTextFactory fullTextFactory) throws EvaluationException {
        this.stream = new FullTextHighlighter(selection, fullTextFactory);
    }

    public int getMaxSnippetSize() {
        return this.maxSnippetSize;
    }

    public void setMaxSnippetSize(int n) {
        this.maxSnippetSize = n;
    }

    public int getMaxWorkSize() {
        return this.maxWorkSize;
    }

    public void setMaxWorkSize(int n) {
        this.maxWorkSize = n;
    }

    public Node makeSnippet(Node node, QName qName, QName qName2, QName qName3, String string) throws DataModelException {
        Check.nonNull(node, "node");
        Check.nonNull(qName, "wrapperElement");
        Check.nonNull(qName2, "hiliterElement");
        this.start(node);
        CorePushBuilder corePushBuilder = new CorePushBuilder(null);
        corePushBuilder.putElementStart(qName);
        while (this.moveToNextEvent() != -1) {
            if (this.getCurrentEvent() == 5 || this.getCurrentEvent() == 9) {
                corePushBuilder.putText(this.getText());
                continue;
            }
            corePushBuilder.putElementStart(qName2);
            if (qName3 != null) {
                corePushBuilder.putAttribute(qName3, string + this.getTermPosition(), null);
            }
            corePushBuilder.putText(this.getText());
            corePushBuilder.putElementEnd(qName2);
        }
        corePushBuilder.putElementEnd(qName);
        return corePushBuilder.harvest();
    }

    public void start(Node node) throws DataModelException {
        int n;
        Chunk chunk;
        int n2;
        Chunk chunk2;
        Chunk chunk3;
        Check.nonNull(node, "node");
        this.stream.start(node);
        this.termCount = this.stream.getQueryTermCount();
        this.chunks = new ArrayList();
        int n3 = 0;
        this.bestScore = 0;
        this.bestChunk = -1;
        while (this.stream.moveToNextEvent() != -1) {
            switch (this.stream.getCurrentEvent()) {
                case 5: {
                    int n4 = this.stream.getWordCount();
                    n3 += n4;
                    this.storeChunk(5, this.stream.getText(), n4, -1);
                    break;
                }
                case 8: {
                    int n4 = this.stream.getWordCount();
                    n3 += n4;
                    this.storeChunk(8, this.stream.getText(), n4, this.stream.getTermPosition());
                    break;
                }
                case 3: {
                    Chunk chunk4 = chunk3 = this.chunks.size() == 0 ? null : this.getChunk(this.chunks.size() - 1, this.chunks);
                    if (chunk3 == null) break;
                    if (chunk3.type != 9) {
                        chunk3 = new Chunk(9, ELLIPSIS, 1, -1);
                        this.chunks.add(chunk3);
                        break;
                    }
                    ++chunk3.wordCount;
                }
            }
            if (n3 <= this.maxWorkSize) continue;
        }
        if (this.bestChunk < 0) {
            if (this.chunks.size() == 0) {
                return;
            }
            this.bestChunk = 0;
        }
        chunk3 = this.getChunk(this.bestChunk, this.chunks);
        this.snippetChunks = new ArrayList();
        this.snippetChunks.add(chunk3);
        int n5 = chunk3.wordCount;
        int n6 = (this.maxSnippetSize - n5 + 1) / 2;
        if (this.bestChunk == 0) {
            n6 = this.maxSnippetSize - n5;
        }
        for (n2 = this.bestChunk + 1; n2 < this.chunks.size() && n6 > 0; n6 -= chunk2.wordCount, ++n2) {
            chunk2 = this.getChunk(n2, this.chunks);
            this.snippetChunks.add(chunk2);
        }
        n6 = (this.maxSnippetSize - n5 + 1) / 2;
        for (n2 = this.bestChunk - 1; n2 >= 0 && n6 > 0; n6 -= chunk2.wordCount, --n2) {
            chunk2 = this.getChunk(n2, this.chunks);
            this.snippetChunks.add(0, chunk2);
        }
        if (this.getChunk((int)0, (ArrayList)this.snippetChunks).type == 9) {
            this.snippetChunks.remove(0);
        }
        n2 = this.snippetChunks.size() - 1;
        if (this.getChunk((int)n2, (ArrayList)this.snippetChunks).type == 9) {
            this.snippetChunks.remove(n2);
        }
        if ((n5 = this.countWords(this.snippetChunks)) > this.maxSnippetSize) {
            for (int i = 0; i < this.snippetChunks.size(); ++i) {
                chunk = this.getChunk(i, this.snippetChunks);
                if (chunk.type != 9 || i + 2 >= this.snippetChunks.size() || this.getChunk((int)(i + 2), (ArrayList)this.snippetChunks).type != 9 || this.getChunk((int)(i + 1), (ArrayList)this.snippetChunks).type != 5) continue;
                this.snippetChunks.remove(i + 2);
                this.snippetChunks.remove(i + 1);
            }
        }
        if ((n = (n5 = this.countWords(this.snippetChunks)) - this.maxSnippetSize) > 0) {
            int n7;
            chunk = this.getChunk(0, this.snippetChunks);
            Chunk chunk5 = this.getChunk(this.snippetChunks.size() - 1, this.snippetChunks);
            int n8 = Math.max(2, chunk.wordCount - n / 3);
            if (this.bestChunk == 0) {
                n8 = Math.min(chunk.wordCount, this.maxSnippetSize);
            }
            if ((n7 = chunk5.wordCount - (n - chunk.wordCount + n8)) <= 0) {
                this.snippetChunks.remove(this.snippetChunks.size() - 1);
            } else {
                chunk5.text = this.stream.extractFirstWords(chunk5.text, n7) + ELLIPSIS;
            }
            if (n8 < chunk.wordCount) {
                chunk.text = ELLIPSIS + this.stream.extractLastWords(chunk.text, n8);
            }
        }
        this.currentChunk = -1;
    }

    private Chunk getChunk(int n, ArrayList arrayList) {
        return (Chunk)arrayList.get(n);
    }

    private int countWords(ArrayList arrayList) {
        int n = 0;
        int n2 = arrayList.size();
        while (--n2 >= 0) {
            Chunk chunk = this.getChunk(n2, arrayList);
            n += chunk.wordCount;
        }
        return n;
    }

    private void storeChunk(int n, String string, int n2, int n3) {
        Chunk chunk = new Chunk(n, string, n2, n3);
        this.chunks.add(chunk);
        if (n != 8) {
            return;
        }
        IntSet intSet = new IntSet(n3);
        int n4 = n2;
        int n5 = n2;
        int n6 = 1;
        int n7 = 0;
        int n8 = this.chunks.size() - 1;
        while (--n8 >= 0) {
            Chunk chunk2 = this.getChunk(n8, this.chunks);
            if ((n4 += chunk2.wordCount) > this.maxSnippetSize) break;
            if (chunk2.type == 8) {
                intSet.add(chunk2.queryPos);
                n5 = n4;
                ++n6;
                continue;
            }
            if (chunk2.type != 0) continue;
            ++n7;
        }
        chunk.score = 10 * intSet.size() + 4 * n6 + Math.min(5, this.maxSnippetSize - n5) - 2 * n7;
        if (chunk.score > this.bestScore) {
            this.bestScore = chunk.score;
            this.bestChunk = this.chunks.size() - 1;
        }
    }

    public int moveToNextEvent() throws DataModelException {
        if (this.snippetChunks == null || ++this.currentChunk >= this.snippetChunks.size()) {
            return this.setEvent(-1);
        }
        return this.setEvent(this.getChunk((int)this.currentChunk, (ArrayList)this.snippetChunks).type);
    }

    public int getTermPosition() {
        return this.getChunk((int)this.currentChunk, (ArrayList)this.snippetChunks).queryPos;
    }

    public int getWordCount() {
        return this.getChunk((int)this.currentChunk, (ArrayList)this.snippetChunks).wordCount;
    }

    public String getText() {
        return this.getChunk((int)this.currentChunk, (ArrayList)this.snippetChunks).text;
    }

    public QName getName() {
        return null;
    }

    public int getQueryTermCount() {
        return this.termCount;
    }

    public String[] getQueryTerms() {
        return this.stream.getQueryTerms();
    }

    public Node getCurrentNode() {
        return null;
    }

    private static class Chunk {
        int type;
        int queryPos;
        int wordCount;
        String text;
        int score;

        public Chunk(int n, String string, int n2, int n3) {
            this.type = n;
            this.text = string;
            this.wordCount = n2;
            this.queryPos = n3;
        }

        public String toString() {
            return this.type == 9 ? "..." : "|" + this.text + "|";
        }
    }
}

