/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util.text;

import com.qizx.api.DataModelException;
import com.qizx.api.Indexing;
import com.qizx.api.util.text.SieveBase;
import com.qizx.util.basic.IntSet;
import com.qizx.util.basic.Util;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class FormatDateSieve
extends SieveBase
implements Indexing.DateSieve {
    public static final String FORMAT = "format";
    public static final String LENIENT = "lenient";
    public static final String TIMEZONE = "timezone";
    public static final String LOCALE = "locale";
    private String formatSrc = "<default>";
    private DateFormat format;
    private transient ParsePosition position = new ParsePosition(0);
    private transient IntSet badFirstChars = null;
    private boolean lenient;

    public FormatDateSieve() {
        this.format = DateFormat.getDateInstance(3);
        this.format.setLenient(false);
    }

    public void setParameters(String[] stringArray) throws DataModelException {
        this.parameters = stringArray;
        TimeZone timeZone = null;
        Locale locale = null;
        for (int i = 0; i < stringArray.length; i += 2) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            if (FORMAT.equals(string)) {
                this.formatSrc = string2;
                continue;
            }
            if (TIMEZONE.equals(string)) {
                timeZone = TimeZone.getTimeZone(string2);
                continue;
            }
            if (LOCALE.equals(string)) {
                locale = Util.getLocale(string2);
                continue;
            }
            if (LENIENT.equals(string)) {
                this.lenient = "true".equalsIgnoreCase(string2) || "yes".equalsIgnoreCase(string2);
                continue;
            }
            throw new DataModelException("invalid parameter " + string);
        }
        if (this.formatSrc == null) {
            throw new DataModelException("format parameter required");
        }
        this.setFormat(this.formatSrc, locale);
        if (timeZone != null) {
            this.format.setTimeZone(timeZone);
        }
        this.format.setLenient(this.lenient);
    }

    public void setFormat(String string, Locale locale) {
        this.formatSrc = string;
        this.format = locale == null ? new SimpleDateFormat(this.formatSrc) : new SimpleDateFormat(this.formatSrc, locale);
        this.format.setLenient(false);
        this.addParameter(FORMAT, string);
    }

    public String getFormat() {
        return this.format instanceof SimpleDateFormat ? ((SimpleDateFormat)this.format).toPattern() : "";
    }

    public synchronized double convert(String string) {
        if (this.badFirstChars != null && this.badFirstChars.test(string.charAt(0))) {
            return Double.NaN;
        }
        this.position.setIndex(0);
        Date date = this.format.parse(string, this.position);
        if (date == null || this.position.getIndex() == 0) {
            if (this.position.getErrorIndex() == 0) {
                if (this.badFirstChars == null) {
                    this.badFirstChars = new IntSet();
                }
                this.badFirstChars.add(string.charAt(0));
            }
            return Double.NaN;
        }
        if (!this.lenient && this.position.getIndex() != string.length()) {
            return Double.NaN;
        }
        return date.getTime();
    }
}

