/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util.time;

import com.qizx.api.util.time.DateTimeBase;
import com.qizx.api.util.time.DateTimeException;
import java.util.Date;

public class DateTime
extends DateTimeBase {
    public DateTime(int n, int n2, int n3, int n4, int n5, double d, int n6, int n7, int n8) throws DateTimeException {
        super(n, n2, n3, n4, n5, d, n6, n7, n8);
    }

    public DateTime(DateTimeBase dateTimeBase) throws DateTimeException {
        this(dateTimeBase.year, dateTimeBase.month, dateTimeBase.day, dateTimeBase.hour, dateTimeBase.minute, dateTimeBase.second, dateTimeBase.tzSign, dateTimeBase.tzHour, dateTimeBase.tzMinute);
    }

    public DateTime(long l) {
        super(l, 0);
    }

    public DateTime(Date date, int n) {
        super(date.getTime(), n);
    }

    public DateTime() {
    }

    public DateTimeBase parse(String string) throws DateTimeException {
        return DateTime.parseDateTime(string);
    }

    public static DateTime parseDateTime(String string) throws DateTimeException {
        int n;
        int[] nArray = new int[3];
        int n2 = string.length();
        if (n2 == 0) {
            throw new DateTimeException("invalid syntax", string);
        }
        int n3 = 0;
        boolean bl = false;
        if (string.charAt(n3) == '-') {
            bl = true;
            ++n3;
        }
        if ((n = string.indexOf(45, n3)) < n3 + 4) {
            throw new DateTimeException("invalid year", string);
        }
        int n4 = DateTime.parseInt(string, n3, n);
        if (n4 < 10000 && n - n3 > 4) {
            throw new DateTimeException("invalid year: leading zeroes", string);
        }
        if (bl) {
            n4 = -n4;
        }
        if ((n3 = n + 1) + 2 >= n2 || string.charAt(n3 + 2) != '-') {
            throw new DateTimeException("invalid month", string);
        }
        int n5 = DateTime.parseInt(string, n3, n3 + 2);
        if ((n3 += 3) + 2 >= n2 || string.charAt(n3 + 2) != 'T') {
            throw new DateTimeException("invalid day", string);
        }
        int n6 = DateTime.parseInt(string, n3, n3 + 2);
        if ((n3 += 3) + 2 >= n2 || string.charAt(n3 + 2) != ':') {
            throw new DateTimeException("invalid syntax", string);
        }
        int n7 = DateTime.parseInt(string, n3, n3 + 2);
        if ((n3 += 3) + 2 >= n2 || string.charAt(n3 + 2) != ':') {
            throw new DateTimeException("invalid syntax", string);
        }
        int n8 = DateTime.parseInt(string, n3, n3 + 2);
        n = DateTime.parseTimeZone(string, n3 += 3, nArray);
        if (n < n3 + 2) {
            throw new DateTimeException("invalid syntax", string);
        }
        double d = DateTime.parseDouble(string, n3, n);
        DateTime dateTime = new DateTime(n4, n5, n6, n7, n8, d, nArray[0], nArray[1], nArray[2]);
        return dateTime;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.year < 0) {
            stringBuffer.append('-');
            DateTime.appendPadded(-this.year, 4, stringBuffer);
        } else {
            DateTime.appendPadded(this.year, 4, stringBuffer);
        }
        stringBuffer.append('-');
        DateTime.appendPadded(this.month, 2, stringBuffer);
        stringBuffer.append('-');
        DateTime.appendPadded(this.day, 2, stringBuffer);
        stringBuffer.append('T');
        DateTime.appendPadded(this.hour, 2, stringBuffer);
        stringBuffer.append(':');
        DateTime.appendPadded(this.minute, 2, stringBuffer);
        stringBuffer.append(':');
        DateTime.appendPadded(this.second, 2, stringBuffer);
        DateTime.appendTimeZone(this.tzSign, this.tzHour, this.tzMinute, stringBuffer);
        return stringBuffer.toString();
    }

    public DateTimeBase copy() {
        try {
            return new DateTime(this.year, this.month, this.day, this.hour, this.minute, this.second, this.tzSign, this.tzHour, this.tzMinute);
        }
        catch (DateTimeException dateTimeException) {
            dateTimeException.printStackTrace();
            return this;
        }
    }
}

