/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util.time;

import com.qizx.api.util.time.DateTimeBase;
import com.qizx.api.util.time.DateTimeException;
import com.qizx.util.basic.Comparison;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class Duration {
    public static DecimalFormat SECOND_FORMAT = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.US));
    private boolean yearMonth;
    private boolean dayTime;
    private int months;
    private double seconds;

    private Duration() {
    }

    public Duration(int n, double d) {
        if ((double)n * d < 0.0) {
            throw new IllegalArgumentException("inconsistent signs");
        }
        this.months = n;
        this.seconds = d;
        this.dayTime = true;
        this.yearMonth = true;
    }

    public static Duration newYearMonth(int n) {
        Duration duration = new Duration();
        duration.yearMonth = true;
        duration.months = n;
        return duration;
    }

    public static Duration newDayTime(double d) {
        Duration duration = new Duration();
        duration.dayTime = true;
        duration.seconds = d;
        return duration;
    }

    public static Duration parseDuration(String string) throws DateTimeException {
        int n = string.length();
        if (n <= 1) {
            throw new DateTimeException("invalid duration", string);
        }
        Duration duration = new Duration();
        int n2 = 0;
        boolean bl = false;
        if (string.charAt(0) == '-') {
            bl = true;
            ++n2;
        }
        if (n2 + 2 >= n || string.charAt(n2) != 'P') {
            throw new DateTimeException("invalid duration (missing 'P')", string);
        }
        ++n2;
        int n3 = string.indexOf(84);
        if (n3 == n - 1) {
            throw new DateTimeException("invalid duration (trailing 'T')", string);
        }
        int n4 = string.indexOf(89, n2);
        if (n4 > n2) {
            duration.months = 12 * DateTimeBase.parseNonNegativeInt(string, n2, n4);
            duration.yearMonth = true;
            n2 = n4 + 1;
        }
        if ((n4 = string.indexOf(77, n2)) > n2 && (n3 < 0 || n4 < n3)) {
            duration.months += DateTimeBase.parseNonNegativeInt(string, n2, n4);
            duration.yearMonth = true;
            n2 = n4 + 1;
        }
        if ((n4 = string.indexOf(68, n2)) > n2) {
            duration.seconds = 86400.0 * (double)DateTimeBase.parseNonNegativeInt(string, n2, n4);
            duration.dayTime = true;
            n2 = n4 + 1;
        }
        if (n3 >= 0) {
            if (n3 == n2) {
                if ((n4 = string.indexOf(72, ++n2)) > n2) {
                    duration.seconds += (double)(3600 * DateTimeBase.parseNonNegativeInt(string, n2, n4));
                    duration.dayTime = true;
                    n2 = n4 + 1;
                }
                if ((n4 = string.indexOf(77, n2)) > n2) {
                    duration.seconds += (double)(60 * DateTimeBase.parseNonNegativeInt(string, n2, n4));
                    duration.dayTime = true;
                    n2 = n4 + 1;
                }
                if ((n4 = string.indexOf(83, n2)) > n2) {
                    duration.seconds += DateTimeBase.parseNonNegativeDouble(string, n2, n4);
                    duration.dayTime = true;
                    n2 = n4 + 1;
                }
            }
            if (!duration.dayTime) {
                throw new DateTimeException("invalid duration", string);
            }
        }
        if (n2 != n || !duration.yearMonth && !duration.dayTime) {
            throw new DateTimeException("invalid duration", string);
        }
        if (bl) {
            duration.seconds = -duration.seconds;
            duration.months = -duration.months;
        }
        return duration;
    }

    public boolean checkAsTimezone() {
        if (this.yearMonth || this.getSeconds() != 0.0) {
            return false;
        }
        int n = this.getHours() * 60 + this.getMinutes();
        return n >= -840 && n <= 840;
    }

    public String toString() {
        long l;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.months < 0 || this.seconds < 0.0 && Math.abs(this.seconds) >= 0.001) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (this.yearMonth && (this.months != 0 || !this.dayTime)) {
            int n;
            int n2 = Math.abs(this.months) / 12;
            if (n2 > 0) {
                stringBuffer.append(n2);
                stringBuffer.append('Y');
            }
            if ((n = Math.abs(this.months) % 12) > 0 || n2 == 0) {
                stringBuffer.append(n);
                stringBuffer.append('M');
            }
        }
        long l2 = l = this.dayTime ? (long)((int)(Math.abs(this.seconds) / 86400.0)) : 0L;
        if (l > 0L) {
            stringBuffer.append(l);
            stringBuffer.append('D');
        }
        double d = Math.abs(this.seconds) - (double)(l * 86400L);
        if (this.dayTime) {
            double d2;
            int n;
            if (d != 0.0) {
                stringBuffer.append('T');
            } else if (l == 0L) {
                if (this.months == 0) {
                    stringBuffer.append("T0S");
                }
                return stringBuffer.toString();
            }
            int n3 = (int)(d / 3600.0);
            if (n3 > 0) {
                stringBuffer.append(n3);
                stringBuffer.append('H');
            }
            if ((n = (int)(d / 60.0) % 60) > 0) {
                stringBuffer.append(n);
                stringBuffer.append('M');
            }
            if ((d2 = d % 60.0) > 0.0) {
                stringBuffer.append(SECOND_FORMAT.format(d2));
                stringBuffer.append('S');
            }
        }
        return stringBuffer.toString();
    }

    public int compareTo(Duration duration) {
        int n = Comparison.of(this.getTotalMonths(), duration.getTotalMonths());
        if (n != 0) {
            return n;
        }
        return Comparison.of(this.getTotalSeconds(), duration.getTotalSeconds());
    }

    public Duration multiply(double d) {
        return new Duration((int)Math.round((double)this.getTotalMonths() * d), this.getTotalSeconds() * d);
    }

    public int getTotalMonths() {
        return this.months;
    }

    public double getTotalSeconds() {
        return this.seconds;
    }

    public boolean isDayTime() {
        return this.dayTime && this.months == 0;
    }

    public boolean isYearMonth() {
        return this.yearMonth && this.seconds == 0.0;
    }

    public Duration copy() {
        Duration duration = new Duration(this.months, this.seconds);
        duration.yearMonth = this.yearMonth;
        duration.dayTime = this.dayTime;
        return duration;
    }

    public int getYears() {
        return this.months / 12;
    }

    public int getMonths() {
        return this.months % 12;
    }

    public int getDays() {
        return (int)(this.seconds / 86400.0);
    }

    public int getHours() {
        long l = (long)(this.seconds / 3600.0);
        return (int)(l % 24L);
    }

    public int getMinutes() {
        long l = (long)(this.seconds / 60.0);
        return (int)(l % 60L);
    }

    public double getSeconds() {
        return this.seconds % 60.0;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.dayTime ? 1231 : 1237);
        n = 31 * n + this.months;
        long l = Double.doubleToLongBits(this.seconds);
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + (this.yearMonth ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Duration duration = (Duration)object;
        if (this.dayTime != duration.dayTime) {
            return false;
        }
        if (this.months != duration.months) {
            return false;
        }
        if (Double.doubleToLongBits(this.seconds) != Double.doubleToLongBits(duration.seconds)) {
            return false;
        }
        return this.yearMonth == duration.yearMonth;
    }
}

