/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.api.util.time;

import com.qizx.api.util.time.DateTimeBase;
import com.qizx.api.util.time.DateTimeException;

public class GYear
extends DateTimeBase {
    public GYear(int n, int n2, int n3, int n4) throws DateTimeException {
        super(n, 1, 1, 0, 0, 0.0, n2, n3, n4);
    }

    public GYear(DateTimeBase dateTimeBase) throws DateTimeException {
        this(dateTimeBase.year, dateTimeBase.tzSign, dateTimeBase.tzHour, dateTimeBase.tzMinute);
    }

    public DateTimeBase parse(String string) throws DateTimeException {
        return GYear.parseGYear(string);
    }

    public static GYear parseGYear(String string) throws DateTimeException {
        int n;
        int[] nArray = new int[3];
        int n2 = string.length();
        if (n2 == 0) {
            throw new DateTimeException("invalid gYear syntax", string);
        }
        int n3 = 0;
        boolean bl = false;
        if (string.charAt(n3) == '-') {
            bl = true;
            ++n3;
        }
        if ((n = GYear.parseTimeZone(string, n3, nArray)) < n3 + 4) {
            throw new DateTimeException("invalid gYear syntax", string);
        }
        int n4 = GYear.parseInt(string, n3, n);
        if (n4 < 10000 && n - n3 > 4) {
            throw new DateTimeException("invalid year: leading zeroes", string);
        }
        if (bl) {
            n4 = -n4;
        }
        return new GYear(n4, nArray[0], nArray[1], nArray[2]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.year < 0) {
            stringBuffer.append('-');
            GYear.appendPadded(-this.year, 4, stringBuffer);
        } else {
            GYear.appendPadded(this.year, 4, stringBuffer);
        }
        GYear.appendTimeZone(this.tzSign, this.tzHour, this.tzMinute, stringBuffer);
        return stringBuffer.toString();
    }
}

