/*
 * Decompiled with CFR 0.152.
 */
package com.qizx.apps;

import com.qizx.api.CompilationException;
import com.qizx.api.EvaluationException;
import com.qizx.api.EvaluationStackTrace;
import com.qizx.api.Expression;
import com.qizx.api.Item;
import com.qizx.api.ItemSequence;
import com.qizx.api.Message;
import com.qizx.api.QName;
import com.qizx.api.QizxException;
import com.qizx.api.XQuerySession;
import com.qizx.api.XQuerySessionManager;
import com.qizx.api.util.DefaultModuleResolver;
import com.qizx.api.util.XMLSerializer;
import com.qizx.apps.util.Property;
import com.qizx.apps.util.QizxConnector;
import com.qizx.restclient.RESTConnection;
import com.qizx.util.basic.CLOptions;
import com.qizx.util.basic.FileUtil;
import com.qizx.util.basic.PathUtil;
import com.qizx.util.basic.Util;
import com.qizx.xquery.ExpressionImpl;
import com.qizx.xquery.XMLExprDisplay;
import com.qizx.xquery.impl.Lexer;
import com.qizx.xquery.impl.NewLexer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;

public class QizxCLI {
    private static final int PUT_MAX_SIZE = 0x1400000;
    static String APP_NAME = "Qizx/open";
    static final String MISSING_LIBRARY = "Library should be specified: use option -l";
    static CLOptions options = new CLOptions(APP_NAME);
    private static QizxCLI app;
    public String importPoint;
    public String[] membersToExport = new String[0];
    public String[] membersToDelete = new String[0];
    public String backupLocation;
    public String checkLogFile;
    public String serverCommand;
    public boolean libraryDelete;
    public boolean createAction;
    public boolean rebuildIndexes;
    public boolean optimize;
    public boolean printVersion;
    public boolean deepCheck;
    public String groupOption;
    public String libraryOption;
    public String login;
    public String baseURI;
    public String moduleBaseURI;
    public String implicitDomain;
    public String xsheetPath;
    public String aclData;
    public String[] includeSuffixes;
    public String[] excludeSuffixes;
    public String[] queryFiles = new String[0];
    public String[] importFiles = new String[0];
    public String[] globals = new String[0];
    public String[] appArgs = new String[0];
    public String timezone;
    public String collation;
    public String[] xmlOptions = new String[0];
    public String outputFile = null;
    public int docCache;
    public int repeats = 1;
    public int muteRepeats;
    public boolean wrapDisplay;
    public boolean verbose;
    public boolean traceJava;
    public boolean traceExceptions;
    public boolean traceQ;
    public boolean traceExpr;
    public boolean traceLex;
    private boolean afterImport;
    private QizxConnector connection;
    private XQuerySession session;
    private XMLSerializer resultOutput;
    private PrintWriter stderr = new PrintWriter(System.err, true);
    private String currentFile;
    private int errorCount = 0;
    private Properties secrets;
    private String password;

    public static void main(String[] stringArray) {
        app = new QizxCLI();
        try {
            options.parse(stringArray, app);
            app.run();
        }
        catch (CLOptions.Error error) {
            System.exit(2);
        }
        catch (Throwable throwable) {
            if (QizxCLI.app.traceExceptions) {
                throwable.printStackTrace();
            } else {
                System.err.println("*** " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
            }
            try {
                if (QizxCLI.app.connection != null) {
                    QizxCLI.app.connection.close();
                }
            }
            catch (Exception exception) {
                System.err.println("emergency close fails: " + exception);
            }
            System.exit(1);
        }
        if (QizxCLI.app.errorCount > 0) {
            System.exit(1);
        }
    }

    public QizxCLI() {
        this.resultOutput = new XMLSerializer();
        this.resultOutput.setIndent(2);
    }

    public void secretAction(String string) throws Exception {
        this.secrets = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.secrets.load(fileInputStream);
            fileInputStream.close();
            this.login = this.secrets.getProperty("login");
            this.password = this.secrets.getProperty("password");
            if (this.login == null || this.password == null) {
                QizxCLI.fatal("secrets file should define properties 'login' and 'password'");
            }
        }
        catch (IOException iOException) {
            QizxCLI.fatal("cannot read secret file: " + iOException.getMessage());
        }
    }

    public void setLoginAction(String string) throws Exception {
        int n = string.indexOf(58);
        if (n > 0) {
            this.password = string.substring(n + 1);
            this.login = string.substring(0, n);
        } else {
            this.login = string;
        }
    }

    public void queryFileAction(String string) throws Exception {
        options.addToField(this, "", "queryFiles", string);
        this.afterImport = false;
    }

    public void fileAction(Boolean bl) throws Exception {
        options.addToField(this, "", "queryFiles", "-");
    }

    public void fileAction(String string) throws Exception {
        if (this.afterImport) {
            options.addToField(this, "", "importFiles", string);
        } else {
            options.addToField(this, "", "queryFiles", string);
        }
    }

    public void importPointAction(String string) throws CLOptions.Error {
        if (this.importPoint != null) {
            throw new CLOptions.Error("option -import can be used only once\n");
        }
        this.importPoint = string;
        this.afterImport = true;
    }

    private static void fatal(String string) {
        System.err.println("*** " + string);
        System.exit(2);
    }

    private void error(String string, Exception exception) {
        this.stderr.println("*** " + string);
        if (this.traceExceptions && exception != null) {
            exception.printStackTrace();
        }
        ++this.errorCount;
    }

    private void warning(String string) {
        this.stderr.println("* warning: " + string);
    }

    private void run() throws Exception {
        if (!(this.libraryDelete || this.createAction || this.importPoint != null || this.queryFiles.length != 0 || this.membersToDelete.length != 0 || this.membersToExport.length != 0 || this.backupLocation != null || this.rebuildIndexes || this.optimize || this.checkLogFile != null || this.serverCommand != null || this.aclData != null || this.printVersion)) {
            QizxCLI.fatal("no command: specify a XQuery file\n Use option -help for more information.");
        }
        if (this.printVersion) {
            this.doPrintVersion();
        }
        for (int i = 0; i < this.queryFiles.length; ++i) {
            InputStreamReader inputStreamReader;
            if (this.connection == null) {
                this.connection = new QizxConnector(this.moduleBaseURI);
            }
            this.currentFile = this.queryFiles[i];
            InputStreamReader inputStreamReader2 = inputStreamReader = "-".equals(this.currentFile) ? new InputStreamReader(System.in) : new FileReader(this.currentFile);
            if (this.connection.isLocal()) {
                this.doExecuteFile(inputStreamReader, this.currentFile);
            } else {
                this.doExecuteFileRemote(inputStreamReader);
            }
            ((Reader)inputStreamReader).close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    private void doPrintVersion() throws Exception {
        if (this.groupOption != null) {
            this.groupConnection();
        }
        if (this.connection == null || this.connection.isLocal()) {
            this.stderr.println("Qizx/open 4.1");
        } else {
            List<Property> list = this.connection.getInfo();
            String string = "";
            String string2 = "";
            for (Property property : list) {
                if (property.name.equals("product-name")) {
                    string = property.value;
                    continue;
                }
                if (!property.name.equals("product-version")) continue;
                string2 = property.value;
            }
            this.stderr.println(string + " " + string2);
        }
    }

    private void doCheckDatabase(String string) throws Exception {
    }

    private void doExecuteFileRemote(Reader reader) throws IOException, QizxException {
        String string = FileUtil.loadString(reader);
        String string2 = this.wrapDisplay ? "items" : "xml";
        String string3 = "UTF-8";
        for (String string4 : this.xmlOptions) {
            if (string4.startsWith("method=")) {
                string2 = string4.substring(7);
                continue;
            }
            if (!string4.startsWith("encoding=")) continue;
            string3 = string4.substring(9);
        }
        InputStream inputStream = this.connection.executeRemote(string, this.libraryOption, string2, string3);
        if (this.outputFile != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(this.outputFile);
            FileUtil.copy(inputStream, fileOutputStream, null);
            fileOutputStream.close();
        } else {
            FileUtil.copy(inputStream, System.out, null);
            System.out.flush();
        }
        inputStream.close();
    }

    private void doExecuteFile(Reader reader, String string) throws Exception {
        block13: {
            Object object;
            Object object2;
            if (this.session == null) {
                this.groupConnection();
                if (this.session == null) {
                    object2 = this.moduleBaseURI != null ? this.moduleBaseURI : ".";
                    object = new XQuerySessionManager(FileUtil.fileToURL((String)object2));
                    this.session = ((XQuerySessionManager)object).createSession();
                }
                this.session.enableJavaBinding(null);
            }
            try {
                if (this.timezone != null) {
                    object2 = TimeZone.getTimeZone(this.timezone);
                    this.session.getContext().setImplicitTimeZone((TimeZone)object2);
                }
                if (this.collation != null) {
                    this.session.getContext().setDefaultCollation(this.collation);
                }
                if (this.baseURI != null) {
                    this.session.getContext().setBaseURI(this.baseURI);
                }
                if ((object2 = PathUtil.getParentPath(string)) != null) {
                    object = FileUtil.fileToURL((String)object2);
                    this.session.setModuleResolver(new DefaultModuleResolver((URL)object));
                }
                if (this.traceLex) {
                    Lexer.debug = true;
                    NewLexer.debug = 1;
                }
                object = FileUtil.loadString(reader);
                Expression expression = this.session.compileExpression((String)object);
                QName qName = this.session.getQName("arguments");
                expression.getContext().declareVariable(qName, null);
                expression.bindVariable(qName, this.appArgs, null);
                for (int i = 0; i < this.globals.length; ++i) {
                    int n = this.globals[i].indexOf(61);
                    if (n < 0) {
                        throw new IllegalArgumentException("illegal variable init: " + this.globals[i]);
                    }
                    String string2 = this.globals[i].substring(0, n);
                    expression.bindVariable(this.session.getQName(string2), this.globals[i].substring(n + 1), null);
                }
                if (this.implicitDomain != null) {
                    Expression expression2 = this.session.compileExpression("fn:collection('" + this.implicitDomain + "')");
                    ItemSequence itemSequence = expression2.evaluate();
                    expression.bindImplicitCollection(itemSequence);
                }
                this.executeAndPrint(expression);
            }
            catch (CompilationException compilationException) {
                this.error(compilationException.getErrorCount() + " parsing/static error(s):", compilationException);
                this.printMessages(compilationException.getMessages());
            }
            catch (Exception exception) {
                ++this.errorCount;
                this.stderr.println("*** " + exception);
                if (!this.traceExceptions) break block13;
                exception.printStackTrace();
            }
        }
    }

    private void groupConnection() throws Exception {
        if (this.connection != null) {
            return;
        }
        if (this.groupOption == null) {
            QizxCLI.fatal("Library Group should be specified: use option -group or -g");
        }
        if (this.remoteServer()) {
            this.connection = new QizxConnector(new RESTConnection(this.groupOption));
        }
    }

    private boolean remoteServer() {
        return this.groupOption != null && this.groupOption.startsWith("http://");
    }

    protected PasswordAuthentication authenticate() {
        if (this.login == null) {
            QizxCLI.fatal("authentication required: see options -auth or -login");
        }
        if (this.password == null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("password: ");
            System.out.flush();
            try {
                this.password = bufferedReader.readLine();
                if (this.password == null) {
                    QizxCLI.fatal("password required");
                }
            }
            catch (Exception exception) {
                QizxCLI.fatal(exception.getMessage());
            }
        }
        return new PasswordAuthentication(this.login, this.password.toCharArray());
    }

    private void displayProgress(double d) {
        long l = Math.round(d * 100.0);
        this.stderr.print(l + " % done\r");
        this.stderr.flush();
        if (d == 1.0) {
            Util.sleep(300);
            this.stderr.println("              ");
        }
    }

    private void printMessages(Message[] messageArray) {
        for (int i = 0; i < messageArray.length; ++i) {
            Message message = messageArray[i];
            String string = message.getModuleURI();
            if (string != null && string.startsWith("file:")) {
                string = string.substring(5);
            }
            this.stderr.print("Error on line " + message.getLineNumber() + " col " + message.getColumnNumber());
            if (string != null) {
                this.stderr.print(" module " + string);
            }
            this.stderr.println(":");
            QName qName = message.getErrorCode();
            String string2 = qName == null ? "<no-code>" : qName.getLocalPart();
            this.stderr.println(" " + string2 + ": " + message.getText());
        }
    }

    private void prepareOutput(XMLSerializer xMLSerializer, String string) throws QizxException, IOException {
        xMLSerializer.reset();
        for (int i = 0; i < this.xmlOptions.length; ++i) {
            int n = this.xmlOptions[i].indexOf(61);
            if (n < 0) {
                throw new QizxException("invalid XML option: " + this.xmlOptions[i]);
            }
            xMLSerializer.setOption(this.xmlOptions[i].substring(0, n), this.xmlOptions[i].substring(n + 1));
        }
        if (string != null) {
            xMLSerializer.setOutput(new FileOutputStream(string), xMLSerializer.getEncoding());
        }
    }

    private void executeAndPrint(Expression expression) throws Exception {
        QName qName = expression.getQName("query-results");
        QName qName2 = expression.getQName("item");
        QName qName3 = expression.getQName("type");
        this.prepareOutput(this.resultOutput, this.outputFile);
        if (this.repeats > 1) {
            this.verbose = true;
        }
        if (this.traceQ) {
            ((ExpressionImpl)expression).setCompilationTrace(new PrintWriter(System.err, true));
        }
        if (this.traceExpr) {
            XMLSerializer xMLSerializer = new XMLSerializer(new PrintWriter(System.err, true));
            xMLSerializer.setIndent(2);
            XMLExprDisplay xMLExprDisplay = new XMLExprDisplay(xMLSerializer);
            ((ExpressionImpl)expression).dump(xMLExprDisplay);
        }
        if (this.muteRepeats > 1) {
            long l = System.currentTimeMillis();
            int n = 0;
            for (int i = 0; i < this.muteRepeats; ++i) {
                ItemSequence itemSequence = expression.evaluate();
                n = (int)((long)n + itemSequence.countItems());
            }
            this.stderr.println("evaluation time " + (float)(System.currentTimeMillis() - l) / (float)this.muteRepeats);
        }
        for (int i = 0; i < this.repeats; ++i) {
            Object object;
            try {
                long l = System.currentTimeMillis();
                object = expression.evaluate();
                long l2 = System.currentTimeMillis();
                int n = 0;
                this.resultOutput.reset();
                if (this.wrapDisplay) {
                    this.resultOutput.putDocumentStart();
                    this.resultOutput.putElementStart(qName);
                }
                while (object.moveToNextItem()) {
                    Item item = object.getCurrentItem();
                    if (this.wrapDisplay) {
                        this.resultOutput.putElementStart(qName2);
                        this.resultOutput.putAttribute(qName3, object.getType().toString(), null);
                    }
                    if (item.isNode()) {
                        object.export(this.resultOutput);
                    } else {
                        if (n > 0 && !this.wrapDisplay) {
                            this.resultOutput.putText(" ");
                        }
                        this.resultOutput.putAtomText(object.getString());
                    }
                    if (this.wrapDisplay) {
                        this.resultOutput.putElementEnd(qName2);
                    }
                    ++n;
                }
                if (this.wrapDisplay) {
                    this.resultOutput.putElementEnd(qName);
                    this.resultOutput.putDocumentEnd();
                }
                this.resultOutput.flush();
                if (this.verbose) {
                    this.stderr.println("-> " + n + " item(s)");
                }
                long l3 = System.currentTimeMillis();
                if (!this.verbose) continue;
                this.stderr.println("evaluation time: " + (l2 - l) + " ms, display time: " + (l3 - l2) + " ms");
                continue;
            }
            catch (EvaluationException evaluationException) {
                ++this.errorCount;
                QName qName4 = evaluationException.getErrorCode();
                this.stderr.println("*** execution error " + (qName4 != null ? qName4.getLocalPart() : "<unknown code>") + ": " + evaluationException.getMessage());
                if (evaluationException.getCause() != null && !this.traceExceptions) {
                    this.stderr.println("  caused by: " + evaluationException.getCause());
                }
                EvaluationStackTrace[] evaluationStackTraceArray = evaluationException.getStack();
                for (int j = 0; j < evaluationStackTraceArray.length; ++j) {
                    object = evaluationStackTraceArray[j];
                    String string = ((EvaluationStackTrace)object).getSignature();
                    string = string == null ? "" : "in " + string;
                    this.stderr.print(string + " at line " + ((EvaluationStackTrace)object).getLineNumber() + " col " + ((EvaluationStackTrace)object).getColumnNumber() + " in ");
                    if (((EvaluationStackTrace)object).getModuleURI() != null) {
                        this.stderr.print(((EvaluationStackTrace)object).getModuleURI());
                    } else {
                        this.stderr.print(this.currentFile);
                    }
                    this.stderr.println();
                }
                if (!this.traceExceptions) continue;
                evaluationException.printStackTrace();
            }
        }
    }

    static {
        options.define(null, "<xquery file>", "!fileAction", "file containing a query to execute.\n");
        options.define("-q_", "<xquery file>", "!queryFileAction", "file containing a query to execute.\nIf file is '-', read from the standard input.\n");
        options.define("-.", "", "!fileAction", null);
        options.defineSection("Server options:");
        options.define("-login_", "<username[:password]>", "!setLoginAction", "define the login name. If authentication is required and\nthe password is not present, it will be read on the console.\nSee also -auth");
        options.define("-auth_", "<file>", "!secretAction", "define the login credentials in a file for security.\nIf authentication is required, credentials will be read from this file.\nThis avoids exposing the password in the command line (with -login).");
        Authenticator.setDefault(new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return app.authenticate();
            }
        });
        options.defineSection("XQuery settings (ignored in client mode):");
        options.define("-i_", "<collection>", "=implicitDomain", "define implicit root for Path expressions: a path expression\nwithout explicit root, like \"//elem\", takes this value as root.\nThis allows writing queries independent of the input data.\nThe value is the same as the argument of function fn:collection():\n- a file path or an URL: for example \"dir1/doc1.xml\"\n- a file pattern: \"dir/*.xml\"\n- a semicolon-separated list of the above elements: \"dir1/*.xml;dir2/doc2.xsl\"\n");
        options.define("-domain_", "<collection>", "=implicitDomain", "alias for option -i (implicit path root)");
        options.define("-D:", "variable_name=value", "+globals", "initialize a XQuery global variable.");
        options.define("--*", "...", "+appArgs", "put all following arguments into XQuery variable '$arguments'");
        options.define("-base-uri_", "<path>", "+baseURI", "define the base URI for locating parsed XML documents.");
        options.define("-module-base-uri_", "<path>", "+moduleBaseURI", "define base URI for XQuery modules");
        options.define("-timezone_", "<time zone>", "+timezone", "implicit timezone in duration format");
        options.define("-collation_", "<collation>", "+collation", "name of default collation");
        options.define("-doc-cache_", "<size_in_Kb>", "=docCache", "define the parsed document cache size (default 8 Mb)");
        options.defineSection("Output options:");
        options.define("-out_", "<output file>", "+outputFile", "output file (defaults to standard output)");
        options.define("-X:", "option=value", "+xmlOptions", "set a XML serialization option.\nFor example -Xmethod=html -Xencoding=ISO-8859-1");
        options.define("-wrap.", "", "=wrapDisplay", "wrap query results in Item description tags");
        options.define("-version.", "", "=printVersion", "display version");
        options.define("-v.", "", "=verbose", "verbose mode");
        options.define("-jt.", "", "=traceJava", "trace Java extension functions");
        options.define("-tex.", "", "=traceExceptions", "display trace of exceptions");
        options.define("-help@", "", "?", "print this help");
        options.define("-r_", "count", "=repeats", null);
        options.define("-mr_", "count", "=muteRepeats", null);
        options.define("-dq.", "", "=traceQ", null);
        options.define("-dx.", "", "=traceExpr", null);
        options.define("-dlex.", "", "=traceLex", null);
    }
}

